<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Apunte extends MY_Controller {

	function __construct()
	{
		parent::__construct();
		// Comunicacion con el modelo
		$this->load->model("curso_model");
        $this->load->model('Apunte_model');
		// $this->load->model("reporte_model");
		// $this->load->model("asistencia_model");
		// $this->load->model("config_model");

	}

	public function index()
	{
        $idInstitucion=$this->session->userdata('idinstitucion');
		$idUsuario=$this->session->userdata('idusuario');
		// $data['paralelos']=$this->curso_model->listarParalelos();
		$data['apuntes']=$this->Apunte_model->obtenerApunte($idUsuario);
		$data1['cursos']=$this->curso_model->listarCursos($idInstitucion);


		$this->load->view('layouts/header'); 
		$this->load->view('layouts/aside',$data1); 
		$this->load->view('apunte/index',$data);
		$this->load->view('layouts/footer');
	}

    public function insert()
    {
        $titulo = $this->input->post('titulo');
        $descripcion = $this->input->post('descripcion');
        $idUsuario=$this->session->userdata('idusuario');
    
        if (!empty($_FILES['imagen']['name'])) {
            // Configuración de subida de imagen
            $upload_path = './files/apuntes/'; // Carpeta donde se guardarán las imágenes
            $config['upload_path'] = $upload_path;
            $config['allowed_types'] = 'jpg|jpeg|png|gif';
            $config['max_size'] = 2048;
            $config['file_name'] = time() . '_' . $_FILES['imagen']['name']; // Nombre único
    
            // Cargar la librería de subida de archivos
            $this->load->library('upload', $config);
    
            if ($this->upload->do_upload('imagen')) {
                $uploadData = $this->upload->data();
                $ruta_imagen = 'files/apuntes/' . $uploadData['file_name']; // Guardamos solo la ruta relativa
    
                // Enviar datos al modelo
                
                $resultado = $this->Apunte_model->insertarApunte($titulo, $descripcion, $ruta_imagen,$idUsuario);
    
                if ($resultado) {
                    echo json_encode(['status' => 'success']);
                } else {
                    echo json_encode(['status' => 'error', 'message' => 'Error al guardar en la base de datos.']);
                }
            } else {
                echo json_encode(['status' => 'error', 'message' => $this->upload->display_errors()]);
            }
        } else {
            echo json_encode(['status' => 'error', 'message' => 'No se subió ninguna imagen.']);
        }
    }

	
	public function delete($id) {
	
		if ($this->Apunte_model->delete($id)) {
			echo json_encode(['success' => true, 'message' => 'Apunte eliminado correctamente']);
		} else {
			echo json_encode(['success' => false, 'message' => 'Error al eliminar el apunte']);
		}
	}
    



}