<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Asistencia extends MY_Controller  {

	function __construct()
	{
		parent::__construct();
		// Comunicacion con el modelo
		$this->load->model("estudiante_model");
		$this->load->model("asistencia_model");
        $this->load->model("curso_model");
        $this->load->model("config_model");
	}

//aqui funciona asistencias
	public function index($idCurso=null, $idParalelo=null)
	{
        $idInstitucion=$this->session->userdata('idinstitucion');
        $idUsuario=$this->session->userdata('idusuario');

        //$numTrimestre=1;
        $trimestreActivo = $this->config_model->obtenerTrimestreActivo();
        $idTrimestreActivo=$trimestreActivo->idTrimestre;
        $nombreTrimestreActivo = $trimestreActivo->nombreTrimestre;
        $trimestre=$this->config_model->obtenerTrimestre($idTrimestreActivo);

        $fechaInicial = $trimestre[0]->fechaInicio;
		$fechaFinal=$trimestre[0]->fechaFinal;

		if ($idCurso === null && $idParalelo === null) {
			// Si no hay valores, usa 1 y 1 por defecto
			$idCurso = 1;
			$idParalelo = 1;
		}

		$fechas=$this->asistencia_model->obtenerFechasAsistencia($fechaInicial,$fechaFinal, $idUsuario);
		$data['fechas']=$fechas;
		$data['estudiantes']=$this->estudiante_model->listarEstudianteParaAsistencia($idCurso, $idParalelo, $idInstitucion);
		$data['asistencias'] = $this->asistencia_model->obtenerAsistencias($idCurso, $idParalelo,$fechas, $idUsuario); 
		$data['curso']=$this->curso_model->obtenerCurso($idCurso, $idParalelo);
		$data1['cursos']=$this->curso_model->listarCursos($idInstitucion); //para el aside
        $data['trimestre']=$nombreTrimestreActivo;
        $data['totalAsistencias']=$this->asistencia_model->obtenerResumenAsistencias($idCurso, $idParalelo, $fechaInicial, $fechaFinal, $idUsuario);
        $data['notificacion']=$this->config_model->obtenerNotificacion($idInstitucion);
		

		$this->load->view('layouts/header'); 
		$this->load->view('layouts/aside',$data1); 
		$this->load->view('asistencia/index',$data);
		$this->load->view('layouts/footer');
	}


	public function insert() {
    $json = file_get_contents('php://input');
    $datos = json_decode($json, true);

    if (!isset($datos['asistencia']) || empty($datos['asistencia'])) {
        echo json_encode(["error" => "No se recibieron datos de asistencia"]);
        return;
    }

    // Obtener el primer registro para extraer la fecha y el primer estudiante
    $primerRegistro = $datos['asistencia'][0];

    if (!isset($primerRegistro['fechaHora']) || empty($primerRegistro['fechaHora'])) {
        echo json_encode(["error" => "La fecha de asistencia está vacía o no fue enviada"]);
        return;
    }

    $fechaSolo = substr($primerRegistro['fechaHora'], 0, 10);
    $idEstudiante = $primerRegistro['idEstudiante'];

    // Verificar si el estudiante ya tiene asistencia en esa fecha
    if ($this->asistencia_model->verificarRegistroExistente($fechaSolo, $idEstudiante)) {
        echo json_encode(["error" => "Ya existe registro para esta fecha"]);
        return;
    }

    // Insertar asistencia para cada estudiante
    foreach ($datos['asistencia'] as $registro) {
        $data = [
            'idEstudiante' => $registro['idEstudiante'],
            'asistencia' => $registro['estado'],
            'fechaHora' => $registro['fechaHora'],
            'idUsuario' => $registro['idUsuario']
        ];

        $this->asistencia_model->insert($data);
    }

    echo json_encode(["success" => "Asistencia registrada correctamente"]);
}


	// public function insert() {

	// 	$json = file_get_contents('php://input');
	// 	$datos = json_decode($json, true);
	
	// 	if (!isset($datos['asistencia']) || empty($datos['asistencia'])) {
	// 		echo json_encode(["error" => "No se recibieron datos de asistencia"]);
	// 		return;
	// 	}
	
	// 	foreach ($datos['asistencia'] as $registro) {
	// 		$data = [
	// 			'idEstudiante' => $registro['idEstudiante'],
	// 			'asistencia' => $registro['estado'], 
	// 			'fechaHora' => $registro['fechaHora'],
	// 			'idUsuario' => $registro['idUsuario']
	// 		];
	
	// 		$this->asistencia_model->insert($data);
	// 	}
	
	// 	echo json_encode(["success" => "Asistencia registrada correctamente"]);
	// }
	
	public function delete()
{
    $data = json_decode(file_get_contents("php://input"), true);
    $fecha = $data['fecha'];
    $ids = $data['ids'];

    if (!empty($ids)) {
        foreach ($ids as $idEstudiante) {
            $this->asistencia_model->delete($fecha, $idEstudiante);
        }
        // Responder con éxito para que la página se recargue
        echo json_encode(["status" => "success", "message" => "Registros eliminados correctamente"]);
    } else {
        echo json_encode(["status" => "error", "message" => "No hay registros para eliminar"]);
    }
}


public function editAsistencia()
{
    $data = json_decode(file_get_contents("php://input"), true);
    $fecha = $data['fecha'];
    $ids = $data['ids'];

    if (!empty($ids)) {
        $asistencias = [];

        foreach ($ids as $idEstudiante) {
            // Consultar la asistencia del estudiante para la fecha dada
            $asistencia = $this->asistencia_model->getAsistenciaPorFecha($fecha, $idEstudiante);
            if ($asistencia) {
                $asistencias[] = $asistencia; // Agregar al array de resultados
            }
        }

        if (!empty($asistencias)) {
            echo json_encode(["status" => "success", "data" => $asistencias]);
        } else {
            echo json_encode(["status" => "error", "message" => "No se encontraron registros"]);
        }
    } else {
        echo json_encode(["status" => "error", "message" => "No se enviaron IDs de estudiantes"]);
    }
}

//actualizar asistencia, que viene del modal
public function update()
{
    // Obtener los datos enviados desde el frontend
    $data = json_decode(file_get_contents("php://input"), true);

    if (!isset($data['asistencia']) || !is_array($data['asistencia'])) {
        echo json_encode(["status" => "error", "message" => "Datos inválidos"]);
        return;
    }

    $asistencias = $data['asistencia'];
    $actualizados = 0;

    foreach ($asistencias as $asistencia) {
        if (isset($asistencia['idAsistencia']) && isset($asistencia['asistencia'])) {
            $resultado = $this->asistencia_model->updateAsistencia($asistencia['idAsistencia'], $asistencia['asistencia']);
            if ($resultado) {
                $actualizados++;
            }
        }
    }

    if ($actualizados > 0) {
        echo json_encode(["status" => "success", "message" => "Asistencias actualizadas correctamente"]);
    } else {
        echo json_encode(["status" => "error", "message" => "No se actualizaron registros"]);
    }
}




}