<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
//para control de inicio de sesion cambio CI_Controller por MY_Controller
class Estudiante extends MY_Controller {

	function __construct()
	{
		parent::__construct();
		// Comunicacion con el modelo
		$this->load->model("estudiante_model");
		$this->load->model("curso_model");
	}


	public function index($idCurso=null, $idParalelo=null)
	{
		if ($idCurso === null && $idParalelo === null) {
			// Si no hay valores, usa 1 y 1 por defecto
			$idCurso = 1;
			$idParalelo = 1;
		}

		$idInstitucion=$this->session->userdata('idinstitucion');

		$data['idInstitucion']=$this->session->userdata('idinstitucion');
		$data['estudiantes']=$this->estudiante_model->listarEstudiante($idCurso, $idParalelo, $idInstitucion);
		$data['curso']=$this->curso_model->obtenerCurso($idCurso, $idParalelo); //obtiene un curso (1ro A)
		$data1['cursos']=$this->curso_model->listarCursos($idInstitucion); //para el aside

		$this->load->view('layouts/header'); 
		$this->load->view('layouts/aside',$data1); 
		$this->load->view('estudiante/index',$data);
		$this->load->view('layouts/footer');
	}

	public function insert()
	{
		$json = file_get_contents('php://input');
		$data = json_decode($json, true);
	
		if (!$data) {
			echo json_encode(["success" => false, "message" => "Datos no válidos"]);
			return;
		}
	
		// Aquí puedes insertar los datos en la base de datos
		$this->db->insert('estudiante', $data);
	
		if ($this->db->affected_rows() > 0) {
			echo json_encode(["success" => true]);
		} else {
			echo json_encode(["success" => false, "message" => "Error al registrar"]);
		}
	}
	

	public function Edit($id=NULL){

		$idInstitucion=$this->session->userdata('idinstitucion');
			$data['getEstudiante']= $this->estudiante_model->getEstudiante($id);
			$data['cursos']=$this->curso_model->listarSoloCursos();
			$data['paralelos']=$this->curso_model->listarParalelos();
			$data1['cursos']=$this->curso_model->listarCursos($idInstitucion);

			$this->load->view('layouts/header'); 
			$this->load->view('layouts/aside',$data1); 
			$this->load->view('estudiante/edit',$data);
			$this->load->view('layouts/footer');
	
	}
	

	public function update() {
		$id = $_POST['txtIdEstudiante'];
		
		$data['nombres'] = $_POST['txtNombres'];
		$data['primerApellido'] = $_POST['txtPrimerApellido'];
		$data['segundoApellido'] = $_POST['txtSegundoApellido'];
		$data['cedula'] = $_POST['txtCi'];
		$data['rude'] = $_POST['txtRude'];
		$data['celular'] = $_POST['txtCelular'];
		$data['idCurso'] = $_POST['cbxCurso'];
		$data['idParalelo'] = $_POST['cbxParalelo'];
	
		// Guardar en variables
		$idCurso = $data['idCurso'];
		$idParalelo = $data['idParalelo'];
	
		// Actualizar en la base de datos
		$this->estudiante_model->update($id, $data);
	
		// Redirigir con los parámetros en la URL
		redirect("estudiante/index/$idCurso/$idParalelo", 'refresh');
	}
	

	public function delete($id) {
	
		if ($this->estudiante_model->delete($id)) {
			echo json_encode(['success' => true, 'message' => 'Estudiante eliminado correctamente']);
		} else {
			echo json_encode(['success' => false, 'message' => 'Error al eliminar el estudiante']);
		}
	}


	public function descargarPlantilla()
{
    require FCPATH . 'vendor/autoload.php';

    $spreadsheet = new \PhpOffice\PhpSpreadsheet\Spreadsheet();
    $sheet = $spreadsheet->getActiveSheet();

    // Definir encabezados
    $sheet->setCellValue('A1', 'Primer Apellido');
    $sheet->setCellValue('B1', 'Segundo Apellido');
    $sheet->setCellValue('C1', 'Nombres');
    $sheet->setCellValue('D1', 'Cédula');
    $sheet->setCellValue('E1', 'Rude');
    $sheet->setCellValue('F1', 'Celular');

    // Aplicar estilos
    $styleArray = [
        'font' => ['bold' => true],
        'alignment' => ['horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER],
        'borders' => ['allBorders' => ['borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN]]
    ];
    $sheet->getStyle('A1:F1')->applyFromArray($styleArray);

    // Crear archivo
    $writer = new \PhpOffice\PhpSpreadsheet\Writer\Xlsx($spreadsheet);
    $filename = 'Plantilla_Estudiantes.xlsx';

    // Enviar archivo al navegador
    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header('Content-Disposition: attachment;filename="' . $filename . '"');
    header('Cache-Control: max-age=0');

    $writer->save('php://output');
    exit;
}


public function subirExcel() {
    require FCPATH . 'vendor/autoload.php';

    if (!empty($_FILES['archivoExcel']['name'])) {
        // Recoger los valores de los IDs enviados
        $idCurso = $this->input->post('idCurso');
        $idParalelo = $this->input->post('idParalelo');
        $idNivel = $this->input->post('idNivel');
        $idInstitucion = $this->input->post('idInstitucion');

        // Obtener el archivo Excel
        $file = $_FILES['archivoExcel']['tmp_name'];
        $spreadsheet = \PhpOffice\PhpSpreadsheet\IOFactory::load($file);
        $sheet = $spreadsheet->getActiveSheet();
        $data = [];

        // Leer las filas del Excel y asociar los IDs
        foreach ($sheet->getRowIterator(2) as $row) {
            $cellIterator = $row->getCellIterator();
            $cellIterator->setIterateOnlyExistingCells(false);

            $fila = [];
            foreach ($cellIterator as $cell) {
                $fila[] = $cell->getValue();
            }

            // Validar datos antes de insertarlos
            if (!empty($fila[0]) && !empty($fila[1])) {
                $data[] = [
                    'primerApellido'  => $fila[0],
                    'segundoApellido' => $fila[1],
                    'nombres' 		  => $fila[2],
                    'cedula'          => $fila[3],
                    'rude'            => $fila[4],
                    'celular'         => $fila[5],
                    'idCurso'         => $idCurso,       // Asignar ID del curso
                    'idParalelo'      => $idParalelo,    // Asignar ID de paralelo
                    'idNivel'         => $idNivel,       // Asignar ID de nivel
                    'idInstitucion'   => $idInstitucion  // Asignar ID de institución
                ];
            }
        }

        // Insertar estudiantes si hay datos válidos
        if (!empty($data)) {
            $this->estudiante_model->insertarEstudiantes($data);
            echo json_encode(["success" => true, "message" => "Estudiantes registrados correctamente."]);
        } else {
            echo json_encode(["success" => false, "message" => "No se encontraron datos válidos."]);
        }
    } else {
        echo json_encode(["success" => false, "message" => "No se subió ningún archivo."]);
    }
}


public function getObservacion()
{
    $data = json_decode(file_get_contents("php://input"), true);
    $idEstudiante = $data['idEstudiante'];

    $resultado = $this->estudiante_model->obtenerObservacion($idEstudiante);

    echo json_encode([
        "status" => "success",
        "observacion" => $resultado['observacion'],
        "estudiante" => $resultado['estudiante']
    ]);
}



public function updateObservacion()
{
    $data = json_decode(file_get_contents("php://input"), true);
    $idEstudiante = $data['idEstudiante'];
    $observacion = $data['observacion'];

    $this->load->model("Estudiante_model");
    $actualizado = $this->estudiante_model->actualizarObservacion($idEstudiante, $observacion);

    if ($actualizado) {
        echo json_encode(["status" => "success", "message" => "Observación actualizada correctamente"]);
    } else {
        echo json_encode(["status" => "error", "message" => "Error al actualizar la observación"]);
    }
}





}