<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Mensaje extends MY_Controller {

	function __construct()
	{
		parent::__construct();
		// Comunicacion con el modelo
		$this->load->model("config_model");
		$this->load->model("curso_model");

	}


	public function index()
	{
		$idInstitucion=$this->session->userdata('idinstitucion');
		$data['citacion']=$this->config_model->obtenerCitacion($idInstitucion);
		$data['notificacion']=$this->config_model->obtenerNotificacion($idInstitucion);
		$data1['cursos']=$this->curso_model->listarCursos($idInstitucion);

		$this->load->view('layouts/header'); 
		$this->load->view('layouts/aside',$data1); 
		$this->load->view('mensaje/index',$data);
		$this->load->view('layouts/footer');
	}

		public function update()
	{
		// Recibir datos por POST
		$mensajeCitacion = $this->input->post('mensajeCitacion', true);
		$mensajeNotificacion = $this->input->post('mensajeNotificacion', true);

		// Validar que los datos no estén vacíos
		if (empty($mensajeCitacion) || empty($mensajeNotificacion)) {
			echo json_encode(['status' => 'error', 'message' => 'Los campos no pueden estar vacíos.']);
			return;
		}

		$idInstitucion=$this->session->userdata('idinstitucion');

		$data['citacion']=$mensajeCitacion;
		$data['notificacion']=$mensajeNotificacion;

		// Llamar al modelo para actualizar los datos
		$resultado = $this->config_model->updateMensajes($idInstitucion, $data);

		if ($resultado) {
			echo json_encode(['status' => 'success', 'message' => 'Mensajes actualizados correctamente.']);
		} else {
			echo json_encode(['status' => 'error', 'message' => 'Error al actualizar los mensajes.']);
		}
	}



}