<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Reporte extends MY_Controller {

	function __construct()
	{
		parent::__construct();
		// Comunicacion con el modelo
		$this->load->model("curso_model");
		$this->load->model("reporte_model");
		$this->load->model("asistencia_model");
		$this->load->model("config_model");

	}

	public function index()
	{
        $idInstitucion=$this->session->userdata('idinstitucion');
		$data['paralelos']=$this->curso_model->listarParalelos();
		$data['cursos']=$this->curso_model->listarSoloCursos();
		$data1['cursos']=$this->curso_model->listarCursos($idInstitucion);


		$this->load->view('layouts/header'); 
		$this->load->view('layouts/aside',$data1); 
		$this->load->view('reporte/index',$data);
		$this->load->view('layouts/footer');
	}

	public function reporteAsistencias()
	{
        $idUsuario=$this->session->userdata('idusuario');
		$fechaInicio = $this->input->post('fechaInicio');
		$fechaFinal = $this->input->post('fechaFinal');
		$idCurso = $this->input->post('curso', true); 
		$idParalelo = $this->input->post('paralelo', true);


		if (empty($fechaInicio) || empty($fechaFinal) || empty($idCurso) || empty($idParalelo)) {
			echo json_encode(['status' => 'error', 'message' => 'Todos los campos son obligatorios']);
			return;
		}


		// Capturar si el modelo retorna NULL
		$reporte = $this->asistencia_model->obtenerResumenAsistencias($idCurso, $idParalelo, $fechaInicio, $fechaFinal, $idUsuario);

		if ($reporte === null) {
			echo json_encode(['status' => 'error', 'message' => 'Error en la consulta']);
			return;
		}

		echo json_encode(['status' => 'success', 'data' => $reporte]);
	}

	public function reporteAsistenciaPorCursoPDF($fechaInicio, $fechaFinal, $idCurso, $idParalelo)
{
    $idUsuario=$this->session->userdata('idusuario');
    $nombreInstitucion=$this->session->userdata('nombreInstitucion');
    $logo=$this->session->userdata('logo');

    $this->load->library('pdf');
    // Capturar los datos del modelo
    $reporte = $this->asistencia_model->obtenerResumenAsistencias($idCurso, $idParalelo, $fechaInicio, $fechaFinal, $idUsuario);
    $curso= $this->curso_model->obtenerCurso($idCurso, $idParalelo);

    $this->pdf = new Pdf();
    $this->pdf->AddPage();
    $this->pdf->AliasNbPages();
    $this->pdf->SetTitle("Asistencia por Curso");
    $this->pdf->SetLeftMargin(15);
    $this->pdf->SetRightMargin(15);
    $this->pdf->SetFont('Arial', 'B', 12);
    $this->pdf->Ln(20);

    // Logo
    $this->pdf->Image($logo, 15, 10, 30); // (x = 15, y = 10, ancho = 30)

    // Nombre de la unidad educativa al lado izquierdo
    $this->pdf->SetXY(55, 10); // Posicionar en X=55 y Y=10 (a la derecha del logo)
    $this->pdf->SetFont('Arial', 'B', 14);
    $this->pdf->Cell(0, 10, strtoupper('UNIDAD EDUCATIVA  '.'"'.$nombreInstitucion.'"'), 0, 1, 'L');

    // Espacio después del logo y nombre de la unidad educativa
    $this->pdf->Ln(10);

    // Agregar color de fondo a la cabecera
    // $this->pdf->SetFillColor(33, 150, 243); // Azul suave
    // $this->pdf->SetTextColor(255, 255, 255); // Texto blanco
    // Mover la posición en X 30 unidades a la derecha
    $this->pdf->SetX(55); // 15 (margen izquierdo) + 30 (desplazamiento adicional)
    $this->pdf->Cell(100, 10, strtoupper('REPORTE DE ASISTENCIAS  -  '.$curso[0]->cortoCurso.' '.$curso[0]->nombreParalelo), 0, 1, 'C');
    $this->pdf->Ln(3);


    // Información general (con borde)
    $this->pdf->SetFillColor(169, 208, 245); // Color celeste para los campos
	$this->pdf->SetTextColor(0, 0, 0); // Texto negro
    $this->pdf->SetFont('Arial', 'B', 10);
    
    // Fecha de inicio y final
    $fechaInicio = date("d/m/Y", strtotime($fechaInicio));
    $fechaFinal = date("d/m/Y", strtotime($fechaFinal));

    $this->pdf->Cell(30, 6, 'Periodo', 1, 0, 'C', 1);
    $this->pdf->Cell(150, 6, 'Desde '.$fechaInicio.' hasta '.$fechaFinal, 1, 0, 'C', 0);

    $this->pdf->Ln(8);
    


    // Cabecera de la tabla con bordes
    $this->pdf->SetFillColor(33, 150, 243); // Cabecera de tabla color azul
    $this->pdf->SetTextColor(255, 255, 255); // Texto blanco

    $this->pdf->SetFont('Arial', 'B', 10);
    $this->pdf->Cell(10, 7, utf8_decode('N°'), 1, 0, 'C', 1);
    $this->pdf->Cell(63, 7, 'Estudiante', 1, 0, 'C', 1);
    $this->pdf->Cell(27, 7, 'Asistencias', 1, 0, 'C', 1);
    $this->pdf->Cell(27, 7, 'Retrasos', 1, 0, 'C', 1);
    $this->pdf->Cell(27, 7, 'Ausencias', 1, 0, 'C', 1);
    $this->pdf->Cell(26, 7, 'Licencias', 1, 0, 'C', 1);
    $this->pdf->Ln(7);

    // Alternar filas de colores para mayor claridad
    $this->pdf->SetFillColor(240, 240, 240); // Color de fondo de las filas
    $this->pdf->SetTextColor(0, 0, 0); // Texto negro
    

    $cont = 0;
    foreach ($reporte as $row) {
        $cont++;
        $estudiante = $row->primerApellido.' '.$row->segundoApellido.' '.$row->nombres;
        $asistencia = $row->totalAsistencias;
        $retraso = $row->totalRetrasos;
        $ausencia = $row->totalAusencias;
        $licencia = $row->totalLicencias;

        // Alternar color de las filas (blanco y gris)
        $fill = ($cont % 2 == 0) ? true : false;

        $this->pdf->SetFont('Arial', '', 10);
        $this->pdf->Cell(10, 5, $cont, 1, 0, 'C', $fill);
        $this->pdf->Cell(63, 5, utf8_decode(ucwords(strtolower($estudiante))), 1, 0, 'L', $fill);
        $this->pdf->Cell(27, 5, $asistencia, 1, 0, 'C', $fill);
        $this->pdf->Cell(27, 5, $retraso, 1, 0, 'C', $fill);
        $this->pdf->Cell(27, 5, $ausencia, 1, 0, 'C', $fill);
        $this->pdf->Cell(26, 5, $licencia, 1, 0, 'C', $fill);
        $this->pdf->Ln(5);
    }

    // Crear y lanzar el PDF
    $ahora = time();
    $ahora = date("d-m-Y H:i:s", $ahora); 
    $this->pdf->Output("Reporte-".$ahora.".pdf", "I");
	}

	public function generarCitacion()
{
    $this->load->library('pdf');

    $idInstitucion=$this->session->userdata('idinstitucion');
    $nombreInstitucion=$this->session->userdata('nombreInstitucion');
    $logo=$this->session->userdata('logo');

    // Capturar los datos enviados por POST
    $nombre = $this->input->post('nombre');
    $cursoNombre = $this->input->post('cursoNombre');
    //$celular = $this->input->post('celular');
    $totalRetrasos = $this->input->post('totalRetrasos');
    $totalAusencias = $this->input->post('totalAusencias');
    $totalLicencias = $this->input->post('totalLicencias');
    $fechaInicio = date("d/m/Y", strtotime($this->input->post('fechaInicio')));
    $fechaFinal = date("d/m/Y", strtotime($this->input->post('fechaFinal')));

    $mensaje = $this->config_model->obtenerCitacion($idInstitucion);

    $this->pdf = new Pdf();
    $this->pdf->AddPage();
    $this->pdf->AliasNbPages();
    $this->pdf->SetTitle(utf8_decode("Citación de Asistencia"));
    $this->pdf->SetMargins(15, 10, 15);
    $this->pdf->SetFont('Arial', '', 12);
    $this->pdf->Ln(5);

    // Logo
    $this->pdf->Image($logo, 15, 10, 30); // (x = 15, y = 10, ancho = 30)
    // Nombre de la unidad educativa al lado izquierdo
    $this->pdf->SetXY(55, 10); // Posicionar en X=55 y Y=10 (a la derecha del logo)
    $this->pdf->SetFont('Arial', 'B', 14);
    $this->pdf->Cell(0, 10, strtoupper('UNIDAD EDUCATIVA  '.'"'.$nombreInstitucion.'"'), 0, 1, 'L');

    // Espacio después del logo y nombre de la unidad educativa
    $this->pdf->Ln(10);

    // Cabecera con fondo azul y texto blanco
    $this->pdf->SetFillColor(255, 255, 255); // Fondo blanco
    $this->pdf->SetTextColor(0, 0, 0); // Texto negro
    $this->pdf->SetFont('Arial', 'BU', 14); // 'U' para subrayado
    $this->pdf->SetX(55); // 15 (margen izquierdo) + 30 (desplazamiento adicional)
    $this->pdf->Cell(100, 10, utf8_decode('CITACIÓN'), 0, 1, 'C', true);
    $this->pdf->Ln(5);

    // Mensaje de citación
    $this->pdf->SetFont('Arial', '', 12);
    $this->pdf->SetTextColor(0, 0, 0);
    $this->pdf->MultiCell(0, 7, utf8_decode($mensaje[0]->citacion), 0, 'J');
    $this->pdf->Ln(2);

    // Datos del Estudiante
    $this->pdf->SetFont('Arial', 'B', 12);
    $this->pdf->Cell(0, 8, utf8_decode('DATOS DEL ESTUDIANTE:'), 0, 1, 'L');
    $this->pdf->Ln(1);

    // Información del estudiante
    $this->pdf->SetFont('Arial', '', 12);
    $this->pdf->Cell(30, 8, 'Estudiante:', 0, 0, 'L');
    $this->pdf->SetFont('Arial', 'B', 12);
    $this->pdf->Cell(0, 8, utf8_decode($nombre), 0, 1, 'L');

    $this->pdf->SetFont('Arial', '', 12);
    $this->pdf->Cell(30, 8, 'Curso:', 0, 0, 'L');
    $this->pdf->SetFont('Arial', 'B', 12);
    $this->pdf->Cell(0, 8, utf8_decode($cursoNombre), 0, 1, 'L');
    $this->pdf->Ln(2);

    // Registro de Asistencia
    $this->pdf->SetFont('Arial', 'B', 12);
    $this->pdf->Cell(0, 8, utf8_decode('REGISTRO DE ASISTENCIA'), 0, 1, 'L');
    $this->pdf->Ln(1);

    // Tabla de registros
    $this->pdf->SetFillColor(200, 220, 255);
    $this->pdf->SetFont('Arial', 'B', 12);
    $this->pdf->Cell(90, 8, 'Periodo', 1, 0, 'C', true);
    $this->pdf->Cell(30, 8, 'Retrasos', 1, 0, 'C', true);
    $this->pdf->Cell(30, 8, 'Ausencias', 1, 0, 'C', true);
    $this->pdf->Cell(30, 8, 'Licencias', 1, 1, 'C', true); // Última celda con salto de línea

    $this->pdf->SetFont('Arial', '', 12);
    $this->pdf->Cell(90, 8, $fechaInicio . ' al ' . $fechaFinal, 1, 0, 'C');
    $this->pdf->Cell(30, 8, $totalRetrasos, 1, 0, 'C');
    $this->pdf->Cell(30, 8, $totalAusencias, 1, 0, 'C');
    $this->pdf->Cell(30, 8, $totalLicencias, 1, 1, 'C'); // Última celda con salto de línea

    $this->pdf->Ln(3);

    // Mensaje de cierre
    $this->pdf->Cell(0, 8, utf8_decode('Agradecemos su pronta asistencia y compromiso con la educación de su hijo/a.'), 0, 1, 'L');
    $this->pdf->Cell(0, 8, 'Atentamente,', 0, 1, 'L');
    $this->pdf->Cell(0, 8, utf8_decode('La Dirección'), 0, 1, 'L');

    // 📌 **Paso 1: Definir la ruta de almacenamiento**
    $rutaDirectorio = FCPATH . 'files/citaciones/'; // Carpeta en la raíz del proyecto
    if (!is_dir($rutaDirectorio)) {
        mkdir($rutaDirectorio, 0777, true); // Crear la carpeta si no existe
    }

    // 📌 **Paso 2: Definir el nombre del archivo**
    $nombreArchivo = preg_replace('/[^a-zA-Z0-9_\-]/', '_', $nombre . "_" . $cursoNombre) . '.pdf'; // Remueve caracteres especiales
    $rutaArchivo = $rutaDirectorio . $nombreArchivo; // Ruta completa del archivo

    // 📌 **Paso 3: Guardar el PDF en la carpeta "citaciones"**
    $this->pdf->Output($rutaArchivo, 'F'); // "F" indica que el archivo se guarda en el servidor

    // 📌 **Paso 4: Devolver la URL para acceder al archivo**
    $urlArchivo = base_url('files/citaciones/' . $nombreArchivo);
    
    echo json_encode(['status' => 'success', 'url' => $urlArchivo, 'nombreArchivo' => $nombreArchivo]);
}


public function descargarCitacion($archivo)
{
    // Ruta de la carpeta donde se guardan los PDFs
    $ruta = FCPATH . "files/citaciones/" . basename($archivo);

    // Verifica si el archivo existe en el sistema de archivos
    if (file_exists($ruta)) {
        // Forzar descarga del archivo
        header('Content-Type: application/pdf');
        header('Content-Disposition: attachment; filename="' . basename($ruta) . '"');
        header('Content-Length: ' . filesize($ruta)); // Opcional: esto puede ayudar a los navegadores a gestionar la descarga mejor.
        readfile($ruta); // Lee el archivo y lo envía al navegador para la descarga
        exit;
    } else {
        show_404(); // Si el archivo no existe, muestra un error 404
    }
}


    public function verDetalle()
    {
        // Capturar los datos enviados por POST
        $idEstudiante = $this->input->post('idEstudiante');
        $fechaInicio = $this->input->post('fechaInicio');
        $fechaFinal = $this->input->post('fechaFinal');

        if (empty($idEstudiante) || empty($fechaInicio) || empty($fechaFinal)) {
            echo json_encode(['status' => 'error', 'message' => 'Faltan datos']);
            return;
        }

        // Obtener la asistencia del estudiante
        $asistencia = $this->asistencia_model->obtenerAsistencia($idEstudiante, $fechaInicio, $fechaFinal);

        // Enviar la respuesta en JSON
        echo json_encode([
            'status' => 'success',
            'data' => $asistencia
        ]);
    }




// generar PDF individual
public function generarPDF() {

    $this->load->library('pdf');

    $idEstudiante = $this->input->post('idEstudiante');
    $fechaInicio = $this->input->post('fechaInicio');
    $fechaFinal = $this->input->post('fechaFinal');
    $cursoNombre = $this->input->post('cursoNombre');

    $idInstitucion=$this->session->userdata('idinstitucion');
    $nombreInstitucion=$this->session->userdata('nombreInstitucion');
    $logo=$this->session->userdata('logo');

    // Obtener la asistencia del estudiante
    $asistencia = $this->asistencia_model->obtenerAsistencia($idEstudiante, $fechaInicio, $fechaFinal);

    $fechaInicio = date("d/m/Y", strtotime($fechaInicio ));
    $fechaFinal = date("d/m/Y", strtotime($fechaFinal));

    if (!$asistencia) {
        echo json_encode(['status' => 'error', 'message' => 'Datos de asistencia no encontrados.']);
        return;
    }

    $this->pdf = new Pdf();
    $this->pdf->AddPage();
    $this->pdf->AliasNbPages();
    $this->pdf->SetTitle(utf8_decode("Citación de Asistencia"));
    $this->pdf->SetMargins(15, 10, 15);
    $this->pdf->SetFont('Arial', '', 12);
    $this->pdf->Ln(5);

    // Logo
    $this->pdf->Image($logo, 15, 10, 30); // (x = 15, y = 10, ancho = 30)
    // Nombre de la unidad educativa al lado izquierdo
    $this->pdf->SetXY(55, 10); // Posicionar en X=55 y Y=10 (a la derecha del logo)
    $this->pdf->SetFont('Arial', 'B', 14);
    $this->pdf->Cell(0, 10, strtoupper('UNIDAD EDUCATIVA  '.'"'.$nombreInstitucion.'"'), 0, 1, 'L');

    // Espacio después del logo y nombre de la unidad educativa
    $this->pdf->Ln(10);

    // Cabecera con fondo azul y texto blanco
    $this->pdf->SetFillColor(255, 255, 255); // Fondo blanco
    $this->pdf->SetTextColor(0, 0, 0); // Texto negro
    $this->pdf->SetFont('Arial', 'BU', 14); // 'U' para subrayado
    $this->pdf->SetX(55); // 15 (margen izquierdo) + 30 (desplazamiento adicional)
    $this->pdf->Cell(100, 10, utf8_decode('REPORTE DE ASISTENCIA'), 0, 1, 'C', true);
    $this->pdf->Ln(5);
    
    // Datos del Estudiante
    $this->pdf->SetFont('Arial', 'B', 12);
    $this->pdf->Cell(0, 8, utf8_decode('DATOS DEL ESTUDIANTE:'), 0, 1, 'L');
    $this->pdf->Ln(1);

            // Información del estudiante
    $this->pdf->SetFont('Arial', '', 12);
    $this->pdf->Cell(30, 8, 'Estudiante:', 0, 0, 'L');
    $this->pdf->SetFont('Arial', 'B', 12);
    $this->pdf->Cell(0, 8, utf8_decode($asistencia['nombreEstudiante']), 0, 1, 'L');

    $this->pdf->SetFont('Arial', '', 12);
    $this->pdf->Cell(30, 8, 'Curso:', 0, 0, 'L');
    $this->pdf->SetFont('Arial', 'B', 12);
    $this->pdf->Cell(0, 8, utf8_decode($cursoNombre), 0, 1, 'L');
    $this->pdf->Ln(2);

    $this->pdf->SetFont('Arial', '', 12);
    $this->pdf->Cell(30, 8, 'Periodo:', 0, 0, 'L');
    $this->pdf->SetFont('Arial', 'B', 12);
    $this->pdf->Cell(0, 8, utf8_decode('Del '.$fechaInicio.' al '.$fechaFinal), 0, 1, 'L');
    $this->pdf->Ln(2);


// Función para formatear fechas
function formatearFecha($fecha) {
    return date("d/m/y", strtotime($fecha));
}

// Definir anchos de columna
$columna1 = 40; // Tipo de falta
$columna2 = 30; // Cantidad
$columna3 = 110; // Fechas (ajustable)

// Agregar bordes a la tabla
$this->pdf->SetFillColor(200, 220, 255); // Color de fondo para la cabecera
$this->pdf->SetFont('Arial', 'B', 12);
$this->pdf->Cell($columna1, 10, 'Tipo', 1, 0, 'C', true);
$this->pdf->Cell($columna2, 10, 'Cantidad', 1, 0, 'C', true);
$this->pdf->Cell($columna3, 10, 'Fechas', 1, 1, 'C', true);
$this->pdf->SetFont('Arial', '', 10);

// Función para agregar filas dinámicas
function agregarFila($pdf, $tipo, $cantidad, $fechas, $columna1, $columna2, $columna3) {
    $pdf->Cell($columna1, 10, utf8_decode($tipo), 1, 0, 'C');
    $pdf->Cell($columna2, 10, $cantidad, 1, 0, 'C');

    // Ajustar el texto dentro de la columna de fechas
    $textoFechas = !empty($fechas) ? implode(", ", array_map('formatearFecha', $fechas)) : "Ninguna";
    $pdf->MultiCell($columna3, 10, utf8_decode($textoFechas), 1, 'L');
}

// Agregar filas
agregarFila($this->pdf, 'Ausencias', $asistencia['totalAusencias'], $asistencia['fechasAusencias'], $columna1, $columna2, $columna3);
agregarFila($this->pdf, 'Retrasos', $asistencia['totalRetrasos'], $asistencia['fechasRetrasos'], $columna1, $columna2, $columna3);
agregarFila($this->pdf, 'Licencias', $asistencia['totalLicencias'], $asistencia['fechasLicencias'], $columna1, $columna2, $columna3);



    // Guardar PDF
    $nombreArchivo = preg_replace('/[^a-zA-Z0-9_\-]/', '_', $asistencia['nombreEstudiante'] . "_" . $cursoNombre) . '.pdf'; // Remueve caracteres especiales
    //$nombreArchivo = 'reporte_' . $idEstudiante . '_' . time() . '.pdf';
    $rutaArchivo = FCPATH . 'files/reports/' . $nombreArchivo;
    $this->pdf->Output($rutaArchivo, 'F');

    // Enviar respuesta JSON con la URL del PDF
    echo json_encode([
        'status' => 'success',
        'pdfUrl' => base_url('files/reports/' . $nombreArchivo),
        'numeroCelular' => $asistencia['numeroCelular'] ?? null
    ]);
}

    

    





}