<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Trimestre extends MY_Controller {

	function __construct()
	{
		parent::__construct();
		// Comunicacion con el modelo
		$this->load->model("config_model");
		$this->load->model("curso_model");

	}


	public function index()
	{
		$idInstitucion=$this->session->userdata('idinstitucion');

		$data['trimestres']=$this->config_model->listarTrimestres();
		$data1['cursos']=$this->curso_model->listarCursos($idInstitucion);

		$this->load->view('layouts/header'); 
		$this->load->view('layouts/aside',$data1); 
		$this->load->view('trimestre/index',$data);
		$this->load->view('layouts/footer');
	}


	public function Edit($id=NULL){
		$idInstitucion=$this->session->userdata('idinstitucion');
		$data['getTrimestre']= $this->config_model->obtenerTrimestre($id);
		$data['cursos']=$this->curso_model->listarCursos($idInstitucion);

		$this->load->view('layouts/header'); 
		$this->load->view('layouts/aside',$data); 
		$this->load->view('trimestre/edit',$data);
		$this->load->view('layouts/footer');
	
	}
	

	public function update(){
		$id=$_POST['txtIdTrimestre'];

		$data['nombreTrimestre']=$_POST['txtNombreTrimestre'];
		$data['fechaInicio']=$_POST['txtFechaInicio'];
		$data['fechaFinal']=$_POST['txtFechaFinal'];

		$this->config_model->updateTrimestre($id,$data);
		redirect('trimestre','refresh');
	}

	public function getTrimestres() {

		$trimestres=$this->config_model->listarTrimestres();
		header('Content-Type: application/json'); // Asegurar JSON
		echo json_encode($trimestres);
	}

	//activar o descativar estado
	public function actualizarTrimestre() {
		$json = file_get_contents('php://input');
		$datos = json_decode($json, true);
	
		if (!isset($datos['idTrimestre'])) {
			echo json_encode(["success" => false, "message" => "Trimestre no válido"]);
			return;
		}
	
		$idNuevoTrimestre = $datos['idTrimestre'];
		
		// Desactivar todos los trimestres
		$this->config_model->desactivarTodos();
	
		// Activar el trimestre seleccionado
		$this->config_model->activarTrimestre($idNuevoTrimestre);
	
		echo json_encode(["success" => true, "message" => "Trimestre actualizado correctamente"]);
	}
	
	



}