<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Usuario extends CI_Controller {

	function __construct()
	{
		parent::__construct();
		// Comunicacion con el modelo
		$this->load->model("usuario_model");
		//$this->load->model("curso_model");
	}

	public function getUsuario() {
        $idUsuario = $this->session->userdata('idusuario');
        
        $data = $this->usuario_model->GetUsuario($idUsuario);

        echo json_encode($data);
		
    }

	public function update()
	{
		$idUsuario = $this->session->userdata('idusuario');
	
		$data = [
			'user'           => $this->input->post('user'),
			'nombres'        => $this->input->post('nombres'),
			'primerApellido' => $this->input->post('primerApellido'),
			'segundoApellido'=> $this->input->post('segundoApellido'),
			'cedula'         => $this->input->post('cedula')
		];

		// Agregar 'pass' solo si tiene contenido
		$pass = trim($this->input->post('pass')); // Elimina espacios en blanco antes y después del valor
		if (!empty($pass)) {
			$data['pass'] = md5($pass);
		}
	
		// Manejo de imagen
		if (!empty($_FILES['imagen']['name'])) {
			$config['upload_path']   = './assets/images/users/'; // Ruta de almacenamiento
			$config['allowed_types'] = 'jpg|jpeg|png'; // Tipos de archivos permitidos
			$config['max_size']      = 2048; // 2MB máximo
			$config['file_name']     = uniqid() . '_' . $_FILES['imagen']['name'];
	
			$this->load->library('upload', $config);
	
			if ($this->upload->do_upload('imagen')) {
				$uploadData = $this->upload->data();
				$data['imagen'] = 'assets/images/users/' . $uploadData['file_name']; // Guardar la ruta en la DB
			} else {
				echo json_encode(['status' => 'error', 'message' => $this->upload->display_errors()]);
				return;
			}
		}
	
		// Actualizar usuario en la DB
		if ($this->usuario_model->updateUsuario($idUsuario, $data)) {
			echo json_encode(['status' => 'success', 'message' => 'Perfil actualizado correctamente']);
		} else {
			echo json_encode(['status' => 'error', 'message' => 'No se pudo actualizar el perfil']);
		}
	}
	






}