<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Apunte_Model extends CI_Model
{

	
	public function obtenerApunte($idUsuario)
	{
		$this->db->select("*");
		$this->db->from('apunte a');
		$this->db->where('a.idUsuario', $idUsuario);
		return $this->db->get()->result();
	}

	public function insertarApunte($titulo, $descripcion, $ruta_imagen, $idUsuario)
    {
        $data = [
            'titulo' => $titulo,
            'descripcion' => $descripcion,
            'imagen' => $ruta_imagen, // Se guarda la ruta de la imagen en la BD
			'idUsuario' => $idUsuario
        ];

        return $this->db->insert('apunte', $data); // Insertar en la tabla 'apunte'
    }


	public function delete($id) {	
	
		$this->db->where('idApunte', $id);
		$this->db->delete('apunte');
	
		return $this->db->affected_rows() > 0; // Retorna true si se modificó al menos una fila
	}




}