<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Asistencia_Model extends CI_Model
{
//aqui funciona asistencias
    public function obtenerFechasAsistencia($fechaInicial, $fechaFinal, $idUsuario) {
        $this->db->select('DATE(fechaHora) as fecha'); // Asegurarse de que DATE() está bien aplicado
        $this->db->from('asistencia a');
        $this->db->where('fechaHora >=', $fechaInicial);
        $this->db->where('fechaHora <=', $fechaFinal);
        $this->db->where('a.idUsuario', $idUsuario);
        $this->db->group_by('DATE(fechaHora)'); // Usamos GROUP BY para asegurar fechas únicas
        $this->db->order_by('fecha', 'ASC');

        $query = $this->db->get();
        return array_column($query->result_array(), 'fecha');
    }

    public function obtenerAsistencias($idCurso, $idParalelo, $fechas, $idUsuario) {
        // Obtenemos todas las fechas de asistencia ya definidas

        if (empty($fechas)) {
            return []; // Si no hay fechas de asistencia, no hay asistencias
        }

        $this->db->select('
            e.idEstudiante, 
            e.nombres, 
            e.primerApellido, 
            DATE(a.fechaHora) as fecha, 
            a.asistencia
        ');
        $this->db->from('estudiante e');
        $this->db->join('asistencia a', 'e.idEstudiante = a.idEstudiante', 'left');
        $this->db->where('e.estado', '1');
        $this->db->where('e.idCurso', $idCurso);
        $this->db->where('e.idParalelo', $idParalelo);
        $this->db->where_in('DATE(a.fechaHora)', $fechas); // Filtrar solo las fechas con asistencia
        $this->db->where('a.idUsuario', $idUsuario);
        $this->db->order_by('e.idEstudiante, a.fechaHora');

        $query = $this->db->get();
        $result = $query->result_array();

        // Organizar los datos en un diccionario
        $asistencias = [];
        foreach ($result as $row) {
            $idEstudiante = $row['idEstudiante'];
            $fecha = $row['fecha'];

            // Si el estudiante aún no ha sido registrado en el array, lo inicializamos
            if (!isset($asistencias[$idEstudiante])) {
                $asistencias[$idEstudiante] = [
                    'idEstudiante' => $idEstudiante,
                    'nombres' => $row['nombres'],
                    'primerApellido' => $row['primerApellido'],
                    'asistencias' => [] // Iniciamos un array vacío de asistencias
                ];
            }

            // Guardamos la asistencia de ese estudiante para la fecha correspondiente
            $asistencias[$idEstudiante]['asistencias'][$fecha] = $row['asistencia'];
        }

        return $asistencias;
    }


    public function obtenerResumenAsistencias($idCurso, $idParalelo, $fechaInicial, $fechaFinal, $idUsuario) {
        // Consulta SQL directa
        $sql = "SELECT 
                    e.idEstudiante, 
                    e.nombres, 
                    e.primerApellido,
                    e.segundoApellido,
                    e.celular, 
                    IFNULL(SUM(CASE WHEN a.asistencia = 1 THEN 1 ELSE 0 END), 0) AS totalAsistencias, 
                    IFNULL(SUM(CASE WHEN a.asistencia = 2 THEN 1 ELSE 0 END), 0) AS totalRetrasos, 
                    IFNULL(SUM(CASE WHEN a.asistencia = 3 THEN 1 ELSE 0 END), 0) AS totalAusencias, 
                    IFNULL(SUM(CASE WHEN a.asistencia = 4 THEN 1 ELSE 0 END), 0) AS totalLicencias 
                FROM 
                    estudiante e 
                RIGHT JOIN 
                    asistencia a ON e.idEstudiante = a.idEstudiante 
                WHERE 
                    e.estado = '1' 
                    AND e.idCurso = ? 
                    AND e.idParalelo = ? 
                    AND DATE(a.fechaHora) >= ? 
                    AND DATE(a.fechaHora) <= ? 
                    AND a.idUsuario = ?
                GROUP BY 
                    e.idEstudiante";
    
        // Ejecución de la consulta con los parámetros
        $query = $this->db->query($sql, array($idCurso, $idParalelo, $fechaInicial, $fechaFinal, $idUsuario));
    
        // Retornar los resultados
        return $query->result();
    }

    public function obtenerTotalAsistenciasDia($fechaDia, $idInstitucion) {
        // Consulta SQL para obtener el total de asistencias por tipo en la institución
        $sql = "SELECT 
                    IFNULL(SUM(CASE WHEN a.asistencia = 1 THEN 1 ELSE 0 END), 0) AS totalAsistencias, 
                    IFNULL(SUM(CASE WHEN a.asistencia = 2 THEN 1 ELSE 0 END), 0) AS totalRetrasos, 
                    IFNULL(SUM(CASE WHEN a.asistencia = 3 THEN 1 ELSE 0 END), 0) AS totalAusencias, 
                    IFNULL(SUM(CASE WHEN a.asistencia = 4 THEN 1 ELSE 0 END), 0) AS totalLicencias
                FROM 
                    estudiante e
                INNER JOIN 
                    asistencia a ON e.idEstudiante = a.idEstudiante
                WHERE 
                    e.estado = '1'
                    AND e.idInstitucion = ?
                    AND DATE(a.fechaHora) = ?";
    
        // Ejecutar la consulta con los parámetros
        $query = $this->db->query($sql, array($idInstitucion, $fechaDia));
    
        // Retornar un solo resultado
        return $query->row();
    }
    
    // para verDetalle el modal en reporte
    public function obtenerAsistencia($idEstudiante, $fechaInicio, $fechaFinal) {
        // Consulta SQL corregida
        $sql = "SELECT 
                    e.nombres, 
                    e.primerApellido, 
                    e.segundoApellido, 
                    e.celular,
                    a.asistencia, 
                    DATE(a.fechaHora) as fecha 
                FROM asistencia a
                JOIN estudiante e ON a.idEstudiante = e.idEstudiante
                WHERE a.idEstudiante = ? 
                AND DATE(a.fechaHora) BETWEEN ? AND ?
                ORDER BY a.fechaHora ASC";
    
        // Ejecutar la consulta
        $query = $this->db->query($sql, array($idEstudiante, $fechaInicio, $fechaFinal));
        $registros = $query->result_array();
    
        // Inicializar contadores
        $asistenciaResumen = [
            'idEstudiante' => $idEstudiante,
            'fechaInicio' => $fechaInicio,
            'fechaFinal' => $fechaFinal,
            'nombreEstudiante' => '',
            'numeroCelular' => '',
            'totalAusencias' => 0,
            'fechasAusencias' => [],
            'totalRetrasos' => 0,
            'fechasRetrasos' => [],
            'totalLicencias' => 0,
            'fechasLicencias' => []
        ];
    
        foreach ($registros as $registro) {
            // Construir el nombre completo del estudiante solo una vez
            if (empty($asistenciaResumen['nombreEstudiante'])) {
                $asistenciaResumen['nombreEstudiante'] = 
                    trim($registro['nombres'] . ' ' . $registro['primerApellido'] . ' ' . $registro['segundoApellido']);
                $asistenciaResumen['numeroCelular'] = $registro['celular']; // Asignar el celular
            }
    
            // Contabilizar asistencias
            switch ($registro['asistencia']) {
                case 3: // AUSENCIA
                    $asistenciaResumen['totalAusencias']++;
                    $asistenciaResumen['fechasAusencias'][] = $registro['fecha'];
                    break;
                case 2: // RETRASO
                    $asistenciaResumen['totalRetrasos']++;
                    $asistenciaResumen['fechasRetrasos'][] = $registro['fecha'];
                    break;
                case 4: // LICENCIA
                    $asistenciaResumen['totalLicencias']++;
                    $asistenciaResumen['fechasLicencias'][] = $registro['fecha'];
                    break;
            }
        }
    
        return $asistenciaResumen;
    }
    
    public function getAsistenciaPorFecha($fecha, $idEstudiante)
    {
        $this->db->select("a.idAsistencia, CONCAT(e.nombres, ' ', e.primerApellido) AS estudiante, a.asistencia, DATE(a.fechaHora) AS fecha", false);
        $this->db->from('estudiante e');
        $this->db->join('asistencia a', 'e.idEstudiante = a.idEstudiante');
        $this->db->where('DATE(a.fechaHora)', $fecha);
        $this->db->where('a.idEstudiante', $idEstudiante);
        $query = $this->db->get();
    
        return $query->row_array(); // Retorna un solo registro
    }


	public function insert($data)
	{
		$this->db->insert('asistencia',$data);
	}

	// no se esta usando
	public function verificarRegistroExistente($fechaSolo, $idEstudiante) {
		// Buscar si existe un registro con la misma fecha (solo la parte de la fecha)
		$this->db->select('idAsistencia');
		$this->db->from('asistencia');
		$this->db->where('idEstudiante', $idEstudiante);
		$this->db->where('DATE(fechaHora)', $fechaSolo); // Compara solo la parte de la fecha
		$query = $this->db->get();
	
		// Si la consulta devuelve algún resultado, significa que ya existe un registro para esa fecha
		if ($query->num_rows() > 0) {
			return true;
		}
	
		return false;
	}
	

	public function delete($fecha, $idEstudiante)
	{	
		$this->db->where("DATE(fechaHora)", $fecha); // Comparar solo la fecha
		$this->db->where("idEstudiante", $idEstudiante);
		$this->db->delete("asistencia");
	}


    public function updateAsistencia($idAsistencia, $asistencia)
{
    $this->db->where("idAsistencia", $idAsistencia);
    return $this->db->update("asistencia", ["asistencia" => $asistencia]);
}


	
}