<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Config_Model extends CI_Model
{

	public function listarTrimestres()
	{
		// $this->db->select("*");
		// $this->db->from('trimestre');
		// return $this->db->get()->result();

		return $this->db->get('trimestre')->result();
	}

	public function obtenerTrimestre($id)
	{
		$this->db->select("*");
		$this->db->from('trimestre');
		$this->db->where('idTrimestre',$id);
		return $this->db->get()->result();
	}

	public function obtenerCitacion($idInstitucion)
	{
		$this->db->select("m.citacion");
		$this->db->from('mensaje m');
		$this->db->where('m.idInstitucion',$idInstitucion);
		return $this->db->get()->result();
	}

	public function obtenerNotificacion($idInstitucion)
	{
		$this->db->select("m.notificacion");
		$this->db->from('mensaje m');
		$this->db->where('m.idInstitucion',$idInstitucion);
		return $this->db->get()->result();
	}

	public function updateMensajes($idInstitucion, $data)
    {
        $this->db->where('idInstitucion', $idInstitucion);
        return $this->db->update('mensaje', $data);
    }

	public function updateTrimestre($idTrimestre, $data)
    {
        $this->db->where('idTrimestre', $idTrimestre);
        return $this->db->update('trimestre', $data);
    }

	public function desactivarTodos() {
        $this->db->update('trimestre', ['estado' => 0]);
    }

    public function activarTrimestre($idTrimestre) {
        $this->db->where('idTrimestre', $idTrimestre);
        $this->db->update('trimestre', ['estado' => 1]);
    }

	public function obtenerTrimestreActivo() {
		$this->db->select('idTrimestre, nombreTrimestre');
		$this->db->from('trimestre');
		$this->db->where('estado', 1);
		$query = $this->db->get();
	
		if ($query->num_rows() > 0) {
			return $query->row(); // Retorna un objeto con idTrimestre y nombreTrimestre
		}
		return null; // Retorna null si no hay trimestre activo
	}




	
}