<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Curso_Model extends CI_Model
{

	//obtiene un solo curso
	public function obtenerCurso($idCurso, $idParalelo)
	{
		$this->db->select("c.idCurso, p.idParalelo, c.nombreCurso, c.cortoCurso, p.nombreParalelo");
		$this->db->from('curso c');
		$this->db->join('curso_paralelo cp','c.idCurso=cp.idCurso');
		$this->db->join('paralelo p','cp.idParalelo=p.idParalelo');
		$this->db->where('c.idCurso', $idCurso);
		$this->db->where('p.idParalelo', $idParalelo);
		return $this->db->get()->result();
	}

	//obtiene lista de cursos
	public function listarCursos($idInstitucion)
	{
		$this->db->select("c.idCurso, p.idParalelo, c.nombreCurso, c.cortoCurso, p.nombreParalelo");
		$this->db->from('curso c');
		$this->db->join('nivel_curso nc','c.idCurso=nc.idCurso');
		$this->db->join('curso_paralelo cp','c.idCurso=cp.idCurso');
		$this->db->join('paralelo p','cp.idParalelo=p.idParalelo');
		$this->db->where('nc.idNivel','2');
		$this->db->where('cp.idInstitucion',$idInstitucion);
		$this->db->order_by('c.cortoCurso ASC, p.nombreParalelo ASC');
		return $this->db->get();
	}

	public function listarParalelos()
	{
		$idInstitucion=$this->session->userdata('idinstitucion');

		$this->db->select("p.idParalelo, p.nombreParalelo");
		$this->db->from("paralelo p");
		$this->db->join("curso_paralelo cp", "p.idParalelo = cp.idParalelo");
		$this->db->where("cp.idInstitucion", $idInstitucion);
		$this->db->group_by("p.idParalelo");

		return $this->db->get()->result();
	}

	public function listarSoloCursos()
	{
		$this->db->select("*");
		$this->db->from('curso');
		return $this->db->get()->result();
	}



	
}