<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Estudiante_Model extends CI_Model
{

	public function listarEstudiante($idCurso, $idParalelo, $idInstitucion)
	{
		
		$this->db->select("*");
		$this->db->from('estudiante e');
		$this->db->where('e.estado','1');
		$this->db->where('e.idCurso',$idCurso);
		$this->db->where('e.idParalelo',$idParalelo);
		$this->db->where('e.idInstitucion',$idInstitucion);
		return $this->db->get()->result();
	}

	public function listarEstudianteParaAsistencia($idCurso, $idParalelo, $idInstitucion)
{
    $this->db->select("DISTINCT e.idEstudiante, e.nombres, e.primerApellido, e.segundoApellido, e.celular, CONCAT(c.cortoCurso, ' ', p.nombreParalelo) AS curso", false);
    $this->db->from('estudiante e');
    $this->db->join('curso c', 'e.idCurso = c.idCurso');
    $this->db->join('paralelo p', 'e.idParalelo = p.idParalelo');
    $this->db->where('e.estado', '1');
    $this->db->where('e.idCurso', $idCurso);
    $this->db->where('e.idParalelo', $idParalelo);
    $this->db->where('e.idInstitucion', $idInstitucion);
    return $this->db->get()->result();
}


	public function insert($data)
	{
		$this->db->insert('estudiante',$data);
	}

	public function insertarEstudiantes($data) {
        $this->db->insert_batch('estudiante', $data);
    }

	public function getEstudiante($id)
	{
		$this->db->select('*');
		$this->db->from('estudiante e');
		$this->db->where('e.idEstudiante', $id);
		return $this->db->get()->result();
	}

	public function update($id, $data)
	{
		$this->db->where('idEstudiante',$id);
		$this->db->update('estudiante',$data);

	}

	public function delete($id) {	
		$data['estado'] = 0;
	
		$this->db->where('idEstudiante', $id);
		$this->db->update('estudiante', $data);
	
		return $this->db->affected_rows() > 0; // Retorna true si se modificó al menos una fila
	}

	public function totalEstudiantes($idInstitucion) {	
		$this->db->select('COUNT(*) as total');
		$this->db->from('estudiante e');
		$this->db->where('e.idInstitucion', $idInstitucion);
		return $this->db->get()->row(); // Retorna un solo resultado
	}
	
	public function obtenerObservacion($idEstudiante)
	{ 
		$this->db->select("IFNULL(e.observacion, 'Ninguno') AS observacion, CONCAT(e.nombres, ' ', e.primerApellido) AS estudiante", false);
		$this->db->from("estudiante e");
		$this->db->where("e.idEstudiante", $idEstudiante);
		$query = $this->db->get();
	
		if ($query->num_rows() > 0) {
			return $query->row_array(); // Devuelve un array con 'observacion' y 'estudiante'
		}
		
		return ["observacion" => "Ninguno", "estudiante" => "Desconocido"]; // Retorno en caso de que no exista
	}
	
	
	
	public function actualizarObservacion($idEstudiante, $observacion)
	{
		$this->db->where("idEstudiante", $idEstudiante);
		return $this->db->update("estudiante", ["observacion" => $observacion]);
	}
	


	
}