<?php
//if ($this->session->userdata('estudiante')) {
?>

<!---script de confirmacion para delete-->
<script type="text/javascript">
    
    function deleteConfirm(id) {
        var baseUrl = "<?= base_url('apunte/delete') ?>";
    if (confirm('¿Está realmente segur@ de eliminar?')) {
        $.ajax({
            url: baseUrl +"/"+ id, // URL del controlador
            type: "POST", // Método HTTP
            dataType: "json", // Tipo de datos esperados en la respuesta
            success: function(response) {
                if (response.success) {
                    swal("El apunte ha sido eliminado correctamente.");
                    location.reload(); // Recargar la página para actualizar la lista
                } else {
                    swal("Error al eliminar el apunte.");
                }
            },
            error: function() {
                swal("Hubo un problema con la solicitud.");
            }
        });
    }
}

</script>



<?php
//print_r($apuntes);

?>




<div class="card mt-3">
    <div class="card-body">
        <!-- Nav tabs -->
        <ul class="nav nav-tabs" role="tablist">
            <li class="nav-item"> <a class="nav-link active" data-toggle="tab" href="#lista" role="tab"><span class="hidden-sm-up"><i class="ti-clipboard"></i></span> <span class="hidden-xs-down">Lista</span></a> </li>
            <li class="nav-item"> <a class="nav-link" data-toggle="tab" href="#agregar" role="tab"><span class="hidden-sm-up"><i class="ti-pencil-alt"></i></span> <span class="hidden-xs-down">Agregar</span></a> </li>
            <li class="nav-item"> <a class="nav-link" data-toggle="tab" href="#messages" role="tab"><span class="hidden-sm-up"><i class=""></i></span> <span class="hidden-xs-down">.</span></a> </li>
            <div class="col-md-7 align-self-center text-right" id=""></div>
            <div class="d-flex">
                <div class="ml-auto ">
                    <div class="form-group">
                        <input id="demo-input-search2" type="text" placeholder="Buscar" autocomplete="off">
                    </div>
                </div>
            </div>
        </ul>
        <!-- Tab panes Lista en tabla -->
        <div class="tab-content tabcontent-border">
            <div class="tab-pane active" id="lista" role="tabpanel">

                <!-- listar -->

                <div class="row el-element-overlay">
                    <div class="col-md-12">
                        <h4 class="card-title">Apuntes personales</h4>
                        <!-- <h6 class="card-subtitle m-b-20 text-muted">You can use by default <code>el-overlay</code></h6>  -->
                    </div>
                    <?php
                    foreach ($apuntes as $row) {
                        ?>
                    <div class="col-lg-3 col-md-6">
                        <div class="card">
                            <div class="el-card-item">
                                <div class="el-card-avatar el-overlay-1"> <img src="<?php echo base_url().$row->imagen; ?>" alt="user" />
                                    <div class="el-overlay">
                                        <ul class="el-info">
                                            <li><a class="btn default btn-outline image-popup-vertical-fit" href="<?php echo base_url().$row->imagen; ?>"><i class="icon-magnifier"></i></a></li>
                                            <li><a class="btn default btn-outline" onclick="deleteConfirm(<?php echo $row->idApunte; ?>)"><i class="icon-trash"></i></a></li>
                                        </ul>
                                    </div>
                                </div>
                                <div class="el-card-content">
                                    <h3 class="box-title"><?php echo $row->titulo; ?></h3> <small><?php echo $row->descripcion; ?></small>
                                    <br/> </div>
                            </div>
                        </div>
                    </div>
                        <?php }?>

                </div>


            </div>


            <div class="tab-pane" id="agregar" role="tabpanel">
                <!-- agregar -->
                <div class="card border-success p-3 form-row has-success" >
                    <label for="titulo" class="form-label success">Título</label>
                    <input type="text" class="form-control mb-2" id="titulo" placeholder="Ingrese un título">

                    <label for="descripcion" class="form-label">Descripción</label>
                    <textarea class="form-control mb-2" id="descripcion" placeholder="Ingrese una descripción"></textarea>

                    <label for="imagen" class="form-label">Cargar Imagen</label>
                    <input type="file" class="form-control mb-2" id="imagen" accept="image/*" onchange="mostrarPrevisualizacion(event)">

                    <div class="mt-3 text-center">
                        <img id="preview" src="" alt="Previsualización" class="img-fluid d-none" style="max-width: 100%; height: auto; border: 1px solid #ddd; padding: 5px; border-radius: 5px;">
                    </div>

                </div>

                <button class="btn btn-success" type="submit" id="btnGuardar" name="btnGuardar"><i class="ti-save"></i> Guardar</button>

            </div>

            <div class="tab-pane" id="messages" role="tabpanel">

                3

            </div>

        </div>
        
    </div>
</div>

</div>
<script>
    function mostrarPrevisualizacion(event) {
        const input = event.target;
        const preview = document.getElementById('preview');

        if (input.files && input.files[0]) {
            const reader = new FileReader();
            
            reader.onload = function(e) {
                preview.src = e.target.result;
                preview.classList.remove('d-none'); // Mostrar la imagen
            };

            reader.readAsDataURL(input.files[0]);
        }
    }

    document.getElementById('btnGuardar').addEventListener('click', function() {
        let titulo = document.getElementById('titulo').value;
        let descripcion = document.getElementById('descripcion').value;
        let imagen = document.getElementById('imagen').files[0];

        if (!titulo || !descripcion || !imagen) {
            alert('Por favor, complete todos los campos.');
            return;
        }

        let formData = new FormData();
        formData.append('titulo', titulo);
        formData.append('descripcion', descripcion);
        formData.append('imagen', imagen);

        fetch('apunte/insert', {
            method: 'POST',
            body: formData
        })
        .then(response => response.json())
        .then(data => {
            if (data.status === 'success') {
                swal({   
                title: "¡Registro exitoso!",   
                text: "El apunte ha sido registrado",   
                timer: 3000,   
                showConfirmButton: true 
            });
            // Esperar 2 segundos (2000 ms) antes de recargar la página
            setTimeout(() => {
                location.reload();
            }, 2000);
                // Opcional: limpiar los campos
                document.getElementById('titulo').value = '';
                document.getElementById('descripcion').value = '';
                document.getElementById('imagen').value = '';
                document.getElementById('preview').classList.add('d-none');
            } else {
                swal('Error al guardar el apunte.');
            }
        })
        .catch(error => {
            console.error('Error:', error);
            swal('Error al procesar la solicitud.');
        });
    });
</script>



<?php 
// }else{
//     redirect('login','refresh');
// }
?>