<?php
//if ($this->session->userdata('estudiante')) {
?>



<!---script de confirmacion para delete-->
<script type="text/javascript">

function deleteConfirm(fecha) {

    var estudiantes = <?php echo json_encode($estudiantes); ?>; // Obtener el array de PHP
    var estudiantesIds = estudiantes.map(e => e.idEstudiante); // Extraer solo los IDs

    swal({   
            title: "¿Estas segur@?",   
            text: "No podrás recuperar las asistencias elminadas!",   
            type: "warning",   
            showCancelButton: true,   
            confirmButtonColor: "#DD6B55",   
            confirmButtonText: "Si, eliminar!",   
            closeOnConfirm: false 
        }, function(){
            fetch("<?php echo base_url('asistencia/delete'); ?>", {
            method: "POST",
            headers: {
                "Content-Type": "application/json",
            },
            body: JSON.stringify({
                fecha: fecha,
                ids: estudiantesIds
            })
        })
        .then(response => response.json()) // Cambiar a .text() para ver la respuesta cruda
        .then(data => {
            //alert(data.message); // Mostrar mensaje
            swal("Eliminado!", "El estudiante ha sido eliminado.", "success");
            if (data.status === "success") {
                location.reload(); // Recargar página solo si fue exitoso
            }
        })
        .catch(error => console.error("Error en la petición:", error));
        });
    
}


//para el editAsistencia
function editAsistencia(fecha) {
    var estudiantes = <?php echo json_encode($estudiantes); ?>; // Obtener el array de PHP
    var estudiantesIds = estudiantes.map(e => e.idEstudiante); // Extraer solo los IDs

    fetch("<?php echo base_url('asistencia/editAsistencia'); ?>", {
        method: "POST",
        headers: {
            "Content-Type": "application/json",
        },
        body: JSON.stringify({
            fecha: fecha,
            ids: estudiantesIds
        })
    })
    .then(response => response.json()) // Cambiar a .text() si quieres ver la respuesta cruda
    .then(data => {
        //console.log("Datos recibidos:", data); // Ver datos en consola
        // Aquí cargaremos el modal con la información
        if (data.status === "success") {
            let tbody = document.getElementById("tablaAsistenciaBody");
            tbody.innerHTML = ""; // Limpiar la tabla antes de cargar

            let estados = ["Vacio", "Presente", "Retraso", "Ausente", "Licencia"];
            let colores = ["btn-light", "btn-success", "btn-warning", "btn-danger", "btn-info"];
            let valores = [0, 1, 2, 3, 4];

            data.data.forEach((item, index) => {
                let estadoActual = parseInt(item.asistencia);
                let nuevoIndice = valores.indexOf(estadoActual);

                let fila = document.createElement("tr");

                fila.innerHTML = `
                    <td>${index + 1}</td>
                    <td>${formatearNombre(item.estudiante)}</td>
                    <td>
                        <button type="button" class="btn ${colores[nuevoIndice]} asistencia1-btn"
                            data-id="${item.idAsistencia}" 
                            data-estado="${estados[nuevoIndice]}"
                            data-valor="${valores[nuevoIndice]}">
                            ${estados[nuevoIndice]}
                        </button>
                    </td>
                `;

                tbody.appendChild(fila);
            });

            // Abrir el modal
            let modal = new bootstrap.Modal(document.getElementById("modalEditarAsistencia"));
            modal.show();
        } else {
            alert("Error al obtener los datos");
        }
    })
    .catch(error => console.error("Error en la petición:", error));
}

// Evento para cambiar estados en los botones de asistencia
document.addEventListener("click", function (e) {
    if (e.target.classList.contains("asistencia1-btn")) {
        let button = e.target;
        let estados = ["Vacio", "Presente", "Retraso", "Ausente", "Licencia"];
        let colores = ["btn-light", "btn-success", "btn-warning", "btn-danger", "btn-info"];
        let valores = [0, 1, 2, 3, 4];

        let estadoActual = button.getAttribute("data-estado");
        let indice = estados.indexOf(estadoActual);
        let nuevoIndice = (indice + 1) % estados.length;

        button.setAttribute("data-estado", estados[nuevoIndice]);
        button.setAttribute("data-valor", valores[nuevoIndice]);
        button.textContent = estados[nuevoIndice];

        button.classList.remove(colores[indice]);
        button.classList.add(colores[nuevoIndice]);

    }
});

// Función para capitalizar cada palabra del nombre
function formatearNombre(nombre) {
    return nombre.toLowerCase().replace(/\b\w/g, char => char.toUpperCase());
}

// funcion para guardar asistencia o btnActualizarAsistencia
document.addEventListener("DOMContentLoaded", function () {
    let btnActualizar = document.getElementById("btnActualizarAsistencia");
    
    if (btnActualizar) {
        btnActualizar.addEventListener("click", function () {
            let filas = document.querySelectorAll("#tablaAsistenciaBody tr"); // Seleccionar todas las filas de la tabla
            let asistenciaData = [];

            filas.forEach(fila => {
                let idAsistencia = fila.querySelector(".asistencia1-btn")?.getAttribute("data-id");
                let asistencia = fila.querySelector(".asistencia1-btn")?.getAttribute("data-valor");

                if (idAsistencia && asistencia) {
                    asistenciaData.push({
                        idAsistencia: idAsistencia,
                        asistencia: asistencia
                    });
                }
            });

            //console.log(asistenciaData);
            fetch("<?= base_url('asistencia/update'); ?>", {
                method: "POST",
                headers: {
                    "Content-Type": "application/json"
                },
                body: JSON.stringify({ asistencia: asistenciaData }) // Enviamos como objeto
            })
            .then(response => response.json())
            .then(data => {
                if (data.status === "success") {
                    swal("Actualizado!", "Los datos de asistencia han sido actualizados.", "success");
                    $("#detalleAsistenciaModal").modal("hide");
                    // Esperar 2 segundos (2000 ms) antes de recargar la página
                    setTimeout(() => {
                        location.reload();
                    }, 2000);
                } else {
                    swal("Error!", data.message, "error");
                }
            })
            .catch(error => console.error("Error en la petición:", error));

        });
    } else {
        console.error("No se encontró el botón btnActualizarAsistencia.");
    }
});



</script>




<?php
// header('Content-Type: application/json');
// echo json_encode($asistencias, JSON_PRETTY_PRINT);
//print_r($asistencias);
//print_r($fechas);
//print_r($notificacion[0]->notificacion);


?>
<!-- //aqui funciona asistencias -->

<!-- Modal editar asistencia inicio -->
<!-- Modal de edición de asistencia -->
<div id="modalEditarAsistencia" class="modal fade" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">

            <!-- Encabezado del Modal -->
            <div class="modal-header bg-success text-white">
                <h4 class="modal-title">Editar de Asistencia</h4>
                <!-- <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button> -->
                <button type="button" class="close" data-dismiss="modal">×</button>
            </div>

            <div class="modal-body">
                <div class="table-responsive">
                    <table class="color-bordered-table info-bordered-table">
                        <thead>
                            <tr>
                                <th>Nro</th>
                                <th>Nombre Completo</th>
                                <th>Asistencia</th>
                            </tr>
                        </thead>
                        <tbody id="tablaAsistenciaBody">
                            <!-- Aquí se insertarán los datos dinámicamente -->
                        </tbody>
                    </table>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default waves-effect" data-dismiss="modal">Cerrar</button>
                <button type="button" id="btnActualizarAsistencia" class="btn btn-success waves-effect waves-light">Guardar Cambios</button>
            </div>
        </div>
    </div>
</div>

<!-- Modal editar asistencia final -->

<div class="card mt-3">
    <div class="card-body">
        <!-- Nav tabs -->
        <ul class="nav nav-tabs" role="tablist">
            <li class="nav-item"> <a class="nav-link active" data-toggle="tab" href="#lista" role="tab"><span class="hidden-sm-up"><i class="ti-clipboard"></i></span> <span class="hidden-xs-down">Asistencia</span></a> </li>
            <li class="nav-item"> <a class="nav-link" data-toggle="tab" href="#agregar" role="tab"><span class="hidden-sm-up"><i class="ti-pencil-alt"></i></span> <span class="hidden-xs-down">Registrar</span></a> </li>
            <li class="nav-item"> <a class="nav-link" data-toggle="tab" href="#totalAsistencias" role="tab"><span class="hidden-sm-up"><i class=""></i></span> <span class="hidden-xs-down">Total</span></a> </li>
            <div class="col-md-7 align-self-center text-right" id=""></div>
            <!-- <div class="d-flex">
                <div class="ml-auto ">
                    <div class="form-group">
                        <input id="demo-input-search2" type="text" placeholder="Buscar" autocomplete="off">
                    </div>
                </div>
            </div> -->
        </ul>
        <!-- Tab panes Lista en tabla -->
        <div class="tab-content tabcontent-border">
            <div class="tab-pane active" id="lista" role="tabpanel">

                    <div class="card-header bg-success">
                    <h4 class="m-b-0 text-white"> 
                    <span class="d-none d-sm-inline">Asistencias:</span>  
                        <strong>
                            <?php 
                            if (!empty($curso) && is_array($curso)) {
                                echo $curso[0]->nombreCurso . " " . $curso[0]->nombreParalelo;
                            }
                            ?>
                        </strong> 
                        <span style="float: right;">
                            <strong><?php echo $trimestre; ?></strong>
                        </span>
                    </h4>
                    </div>
                    <br>

                <!-- listar -->
                <div style="overflow-x:auto;" class="table-responsive">
                    <table  class="color-bordered-table info-bordered-table" data-page-size="20">  <!--class="table" ---- id="demo-foo-addrow2" -->
                    
                    <thead>
                        <tr>
                            <th>Nro</th>
                            <th class="nombre-columna nombre-col">Nombre Completo</th> <!-- Columna fija -->
                            <?php 
                            // Verificar si hay fechas
                            if (!empty($fechas)) {
                                foreach ($fechas as $fecha) {
                                    if (!empty($fecha) && strtotime($fecha)) {
                                        echo "<th class='fecha'>" . date("d/m", strtotime($fecha)) . 
                                            "<br><br> <div class='btn-group'>
                                                <button type='button' class='btn btn-xs btn-danger dropdown-toggle btn-sm' data-toggle='dropdown' aria-haspopup='true' aria-expanded='false'>
                                                    <i class='ti-arrow-circle-down'></i>
                                                </button>
                                                <div class='dropdown-menu p-1'>
                                                    <a class='dropdown-item text-white bg-danger btn-sm px-2 py-1 rounded' href='#' onclick='deleteConfirm(\"$fecha\")'>
                                                        <i class='ti-trash'></i> Eliminar
                                                    </a>
                                                    <a class='dropdown-item text-white bg-warning btn-sm px-2 py-1 rounded mt-1' href='#' onclick='editAsistencia(\"$fecha\")'>
                                                        <i class='ti-pencil-alt'></i> Editar
                                                    </a>
                                                </div>
                                            </div>
                                        </th>";
                                    }
                                }
                            } else {
                                echo "<th colspan='100%'>No hay fechas disponibles.</th>";
                            }
                            ?>
                        </tr>
                    </thead>

                    <tbody>
                        <?php 
                        // Verificar si hay asistencias
                        if (!empty($asistencias)) {
                            $indice = 1;
                            foreach ($asistencias as $idEstudiante => $row) {
                                echo "<tr>";
                                echo "<td>" . $indice . "</td>";
                                echo "<td class='nombre-columna nombre-col'>" . ucwords(strtolower($row['primerApellido'] . ' ' . $row['nombres'])) . "</td>";


                                // Mostrar las asistencias para cada fecha
                                foreach ($fechas as $fecha) {
                                    if (isset($row['asistencias'][$fecha])) {
                                        switch ($row['asistencias'][$fecha]) {
                                            case 1:
                                                echo "<td class='presente'>P</td>";
                                                break;
                                            case 2:
                                                echo "<td class='retraso'>R</td>";
                                                break;
                                            case 3:
                                                echo "<td class='ausente'>A</td>";
                                                break;
                                            case 4:
                                                echo "<td class='licencia'>L</td>";
                                                break;
                                            default:
                                                echo "<td class='desconocido'>-</td>";
                                                break;
                                        }
                                    } else {
                                        // Si no hay asistencia para esa fecha, muestra un guion
                                        echo "<td class='desconocido'>-</td>";
                                    }
                                }
                                echo "</tr>";
                                $indice++;
                            }
                        } else {
                            echo "<tr><td colspan='" . (count($fechas) + 2) . "'>No hay registros de asistencia disponibles.</td></tr>";
                        }
                        ?>
                    </tbody>


                        <tfoot>
                            <tr>
                                <td colspan="6">
                                    <div class="text-right">
                                        <ul class="pagination">
                                        </ul>
                                    </div>
                                </td>
                            </tr>
                        </tfoot>
                        </table>
                        </div>
                        
                        
            </div>

            <div class="tab-pane" id="agregar" role="tabpanel">
                <div class="card border-success">
                    <div class="card-header bg-success">
                    <h4 class="m-b-0 text-white"> 
                    <span class="d-none d-sm-inline">Registrar:</span>
                            <strong><?php 
                            if (!empty($curso) && is_array($curso)) {echo $curso[0]->nombreCurso . " " . $curso[0]->nombreParalelo;}
                            ?></strong>
                            <span style="float: right;">
                            <strong><?php echo $trimestre; ?></strong>
                        </span>
                        </h4>
                    </div>
                    <br>
                    
                    <div class="row align-items-center flex-nowrap">
                        <span class="d-none d-sm-inline col-auto">Fecha y Hora:</span>

                        <div class="col-auto">
                            <input type="date" id="fecha" class="form-control">
                        </div>

                        <div class="col-auto">
                            <input type="time" id="hora" class="form-control">
                        </div>

                        <div class="col-auto">
                            <button class="btn btn-success" type="button" name="cambiarEstado">
                                <i class="ti-reload"></i> Cambio
                            </button>
                        </div>
                    </div>


                    
                        

                        <div class="table-responsive">
                            <table class="color-bordered-table info-bordered-table"> <!-- id="demo-foo-addrow2" class="table color-bordered-table info-bordered-table"   data-page-size="10" -->
                                
                                <thead>
                                    <tr>
                                        <th>Nro</th>
                                        <th>Nombre Completo</th>
                                        <th>Asistencia</th>
                                        <th>Notificación</th>
                                    </tr>
                                </thead>

                                <tbody>
                                    <?php
                                    $indice = 1;
                                    foreach ($estudiantes as $row) {
                                        ?>
                                        <tr>
                                            <td><?php echo $indice; ?></td>
                                            <td><?php echo ucwords(strtolower($row->primerApellido . ' ' . $row->segundoApellido . ' ' . $row->nombres)); ?></td>
                                            </td>

                                            <td>
                                            <button type="button" class="btn btn-light asistencia-btn"
                                                data-id="<?php echo $row->idEstudiante; ?>" 
                                                data-estado="vacio"
                                                data-valor="0">
                                                Vacío
                                            </button>
                                            </td>
                                            <td>
                                                <button type="button" class="btn btn-secondary notificar-btn" 
                                                    data-id="<?php echo $row->idEstudiante; ?>" 
                                                    data-nombre="<?php echo $row->nombres." ".$row->primerApellido; ?>"
                                                    data-celular="<?php echo $row->celular; ?>"
                                                    style="display: none;">
                                                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-whatsapp" viewBox="0 0 16 16">
                                                        <path d="M13.601 2.326A7.85 7.85 0 0 0 7.994 0C3.627 0 .068 3.558.064 7.926c0 1.399.366 2.76 1.057 3.965L0 16l4.204-1.102a7.9 7.9 0 0 0 3.79.965h.004c4.368 0 7.926-3.558 7.93-7.93A7.9 7.9 0 0 0 13.6 2.326zM7.994 14.521a6.6 6.6 0 0 1-3.356-.92l-.24-.144-2.494.654.666-2.433-.156-.251a6.56 6.56 0 0 1-1.007-3.505c0-3.626 2.957-6.584 6.591-6.584a6.56 6.56 0 0 1 4.66 1.931 6.56 6.56 0 0 1 1.928 4.66c-.004 3.639-2.961 6.592-6.592 6.592m3.615-4.934c-.197-.099-1.17-.578-1.353-.646-.182-.065-.315-.099-.445.099-.133.197-.513.646-.627.775-.114.133-.232.148-.43.05-.197-.1-.836-.308-1.592-.985-.59-.525-.985-1.175-1.103-1.372-.114-.198-.011-.304.088-.403.087-.088.197-.232.296-.346.1-.114.133-.198.198-.33.065-.134.034-.248-.015-.347-.05-.099-.445-1.076-.612-1.47-.16-.389-.323-.335-.445-.34-.114-.007-.247-.007-.38-.007a.73.73 0 0 0-.529.247c-.182.198-.691.677-.691 1.654s.71 1.916.81 2.049c.098.133 1.394 2.132 3.383 2.992.47.205.84.326 1.129.418.475.152.904.129 1.246.08.38-.058 1.171-.48 1.338-.943.164-.464.164-.86.114-.943-.049-.084-.182-.133-.38-.232"/>
                                                    </svg>
                                                    Enviar
                                                </button>
                                            </td>

                                        </tr>
                                        <?php
                                        $indice++;
                                    }
                                    ?>
                                </tbody>
                            </table>
                        </div>
                            <br>
                        <div>
                        <button class="btn btn-success" type="button" id="btnGuardar"><i class="ti-save"></i> Registrar</button>
                        <a class="btn btn-dark" href="<?php echo base_url('asistencia') ?>"><i class="ti-angle-double-left"></i> Cancelar</a>
                        </div>
                    
                </div>
            </div>

            <div class="tab-pane" id="totalAsistencias" role="tabpanel">

                <div class="card-header bg-success">
                <h4 class="m-b-0 text-white"> 
                <span class="d-none d-sm-inline">Totales:</span> 
                        <strong><?php 
                        if (!empty($curso) && is_array($curso)) {echo $curso[0]->nombreCurso . " " . $curso[0]->nombreParalelo;}
                        ?></strong>
                        <span style="float: right;">
                            <strong><?php echo $trimestre; ?></strong>
                        </span>
                    </h4>
                </div>
                <br>

            <!-- listar -->
            <div style="overflow-x:auto;" class="table-responsive">
                    <table id="demo-foo-addrow2" class="color-bordered-table info-bordered-table" data-page-size="20">
                        <thead>
                            <tr>
                                <th data-sort-initial="false" data-toggle="true">Nro</th>
                                <th class="nombre-columna nombre-col">Estudiante</th>
                                <th data-sort-ignore="true">Asistencias</th>
                                <th data-sort-ignore="true">Retrasos</th>
                                <th data-sort-ignore="true" class="min-width">Ausencias</th>
                                <th data-sort-ignore="true" class="min-width">Licencias</th>
                            </tr>
                        </thead>



                        <tbody>
                            <?php
                            $indice=1;
                        foreach ($totalAsistencias as $row) { ?>
                            <tr>
                                <td><?php echo $indice; ?></td>
                                <td><?php echo ucwords(strtolower($row->primerApellido . ' ' . $row->nombres)); ?></td>
                                <td><?php echo $row->totalAsistencias; ?></td>
                                <td><?php echo $row->totalRetrasos; ?></td>
                                <td><?php echo $row->totalAusencias; ?></td>
                                <td><?php echo $row->totalLicencias; ?></td>
                            </tr>
                            <?php
                            $indice++;
                        }?>

                            <!-- <td>-</td>
                            <td class="nombre-columna nombre-col">-</td>
                            <td>-</td>
                            <td>-</td>
                            <td>-</td>
                            <td>-</td> -->

                        </tbody>
                        <tfoot>
                            <tr>
                                <td colspan="6">
                                    <div class="text-right">
                                        <ul class="pagination">
                                        </ul>
                                    </div>
                                </td>
                            </tr>
                        </tfoot>
                    </table>
                </div>
            
            </div>

        </div>

        

    </div>
</div>



<script>
    document.addEventListener("DOMContentLoaded", function () {
    let ahora = new Date();
    document.getElementById("fecha").value = ahora.toISOString().split("T")[0];
    document.getElementById("hora").value = ahora.toTimeString().slice(0, 5);

    // Manejo de los botones de asistencia
    // Manejo de los botones de asistencia
document.querySelectorAll(".asistencia-btn").forEach(button => {
    let notificarBtn = button.closest("td").nextElementSibling.querySelector(".notificar-btn");

    button.addEventListener("click", function () {
        // Estados y configuraciones
        let estados = ["vacio", "presente", "retraso", "ausente", "licencia"];
        let colores = ["btn-light", "btn-success", "btn-warning", "btn-danger", "btn-info"];
        let valores = [0, 1, 2, 3, 4]; 
        let textos = ["Vacío", "Presente", "Retraso", "Ausente", "Licencia"];

        let estadoActual = this.getAttribute("data-estado");
        let indice = estados.indexOf(estadoActual);
        let nuevoIndice = (indice + 1) % estados.length;

        this.setAttribute("data-estado", estados[nuevoIndice]);
        this.setAttribute("data-valor", valores[nuevoIndice]);
        this.textContent = textos[nuevoIndice];

        this.classList.remove(colores[indice]);
        this.classList.add(colores[nuevoIndice]);

        // Mostrar el botón Notificar solo si está en "Retraso", "Ausente" o "Licencia"
        if (valores[nuevoIndice] === 2 || valores[nuevoIndice] === 3 || valores[nuevoIndice] === 4) {
            notificarBtn.style.display = "inline-block";
            notificarBtn.setAttribute("data-estado", textos[nuevoIndice]); // Guardar estado en notificar-btn
        } else {
            notificarBtn.style.display = "none";
        }
    });
});

// Manejo del botón general de cambio de estado
document.querySelector("button[name='cambiarEstado']").addEventListener("click", function () {
    let estadoGlobal = this.getAttribute("data-global-estado") === "presente" ? "vacio" : "presente";
    let colorGlobal = estadoGlobal === "presente" ? "btn-success" : "btn-light";
    let valorGlobal = estadoGlobal === "presente" ? 1 : 0;
    let textoGlobal = estadoGlobal === "presente" ? "Presente" : "Vacío";
    
    document.querySelectorAll(".asistencia-btn").forEach(button => {
        button.setAttribute("data-estado", estadoGlobal);
        button.setAttribute("data-valor", valorGlobal);
        button.textContent = textoGlobal;

        button.classList.remove("btn-light", "btn-success");
        button.classList.add(colorGlobal);
    });

    this.setAttribute("data-global-estado", estadoGlobal);
});

    // Manejo del botón Notificar
    document.querySelectorAll(".notificar-btn").forEach(button => {
    button.addEventListener("click", function () {
        let nombre = this.getAttribute("data-nombre"); // Nombre del estudiante
        let celular = this.getAttribute("data-celular"); // Número de WhatsApp
        let fecha = document.getElementById("fecha").value;
        let estado = this.getAttribute("data-estado");
        // Agregar código de país si no está
        if (!celular.startsWith("591")) {
            celular = "591" + celular;
        }

        let notificacion = JSON.parse('<?php echo json_encode($notificacion[0]->notificacion); ?>');

        let estadoMensaje = {
            "retraso": "se retrasó",
            "ausente": "se ausentó",
            "licencia": "solicitó licencia"
        };

        // Si el estado existe en el objeto, usa su valor; de lo contrario, usa el estado original.
        let estadoFormateado = estadoMensaje[estado.toLowerCase()] || `se ${estado.toLowerCase()}`;

        let mensaje = `${notificacion} ${nombre}, el día ${fecha}, ${estadoFormateado}. Rogamos realizar seguimiento.`;

        // Codificar mensaje para URL
        let mensajeCodificado = encodeURIComponent(mensaje);
        let urlWhatsApp = `https://wa.me/${celular}?text=${mensajeCodificado}`;

        // Abrir WhatsApp en una nueva ventana
        window.open(urlWhatsApp, "_blank");
    });
});

    // Manejar el envío de asistencia al servidor
    document.getElementById("btnGuardar").addEventListener("click", function (event) {
        event.preventDefault(); // Evitar recarga de la página

        let asistencia = [];
        let fecha = document.getElementById("fecha").value;
        let hora = document.getElementById("hora").value;
        let fechaHora = `${fecha} ${hora}:00`;

        document.querySelectorAll(".asistencia-btn").forEach(button => {
            let idEstudiante = button.getAttribute("data-id");
            let estado = button.getAttribute("data-valor");
            let idUsuario = <?php echo json_encode($this->session->userdata('idusuario')); ?>;

            asistencia.push({
                idEstudiante: idEstudiante,
                estado: estado,
                fechaHora: fechaHora,
                idUsuario: idUsuario
            });
        });

        // Verificar si hay datos antes de enviar
        if (asistencia.length === 0) {
            swal("No hay datos de asistencia para enviar.");
            return;
        }

        fetch("<?= base_url('asistencia/insert') ?>", {  
            method: "POST",
            headers: {
                "Content-Type": "application/json"
            },
            body: JSON.stringify({ asistencia: asistencia })
        })
        .then(response => response.json())  
        .then(data => {
            if (data.success) {

            swal("¡Registro exitoso!", "La asistencia ha sido registrado.", "success");
            // Esperar 2 segundos (2000 ms) antes de recargar la página
            setTimeout(() => {
                location.reload();
            }, 2000);
            } else {
                swal(data.error || "Error desconocido al guardar la asistencia.");
            }
        })
        .catch(error => {
            console.error("Error en la petición fetch:", error);
            swal("Hubo un error al enviar los datos.");
        });
    });
});




</script>

<?php
// }else{
//     redirect('login','refresh');
// }
?>