<?php
//if ($this->session->userdata('estudiante')) {
?>

<!---script de confirmacion para delete-->
<script type="text/javascript">

    function deleteConfirm(id) {
        var baseUrl = "<?= base_url('estudiante/delete') ?>";

            swal({   
            title: "¿Estas segur@?",   
            text: "No podrás recuperar el estudiante elminado!",   
            type: "warning",   
            showCancelButton: true,   
            confirmButtonColor: "#DD6B55",   
            confirmButtonText: "Si, eliminar!",   
            closeOnConfirm: false 
        }, function(){
            $.ajax({
            url: baseUrl +"/"+ id, // URL del controlador
            type: "POST", // Método HTTP
            dataType: "json", // Tipo de datos esperados en la respuesta
            success: function(response) {
                if (response.success) {
                    //alert("El estudiante ha sido eliminado correctamente.");
                    swal("Eliminado!", "El estudiante ha sido eliminado.", "success");
                    location.reload(); // Recargar la página para actualizar la lista
                } else {
                    swal("Error al eliminar el estudiante.");
                }
            },
            error: function() {
                swal("Hubo un problema con la solicitud.");
            }
        });
            
        });
}



</script>



<?php
//print_r($idInstitucion);

?>

<!-- Modal observacion estudiante inicio -->
<div id="modalObservacion" class="modal fade" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <!-- Encabezado del Modal -->
            <div class="modal-header bg-success text-white">
                <h4 class="modal-title">Observaciones del estudiante</h4>
                
                <button type="button" class="close" data-dismiss="modal">×</button>
            </div>

            <div class="modal-body has-success">
                <div class="mb-3 text-center">
                    <h4 class="fw-bold">Estudiante: <span id="estudianteOb"></span></h4>
                </div>

                <input type="hidden" id="idEstudianteInput">
                <div class="form-group">
                    <label for="observacionInput">Observación</label>
                    <textarea type="text" id="observacionInput" name="observacionInput" class="form-control" rows="12"></textarea>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancelar</button>
                <button type="button" id="btnActualizarObservacion" class="btn btn-primary">Guardar Cambios</button>
            </div>
        </div>
    </div>
</div>

<!-- Modal observacion estudiante final -->

<div class="card mt-3">
    <div class="card-body">
        <!-- Nav tabs -->
        <ul class="nav nav-tabs" role="tablist">
            <li class="nav-item"> <a class="nav-link active" data-toggle="tab" href="#lista" role="tab"><span class="hidden-sm-up"><i class="ti-clipboard"></i></span> <span class="hidden-xs-down">Lista</span></a> </li>
            <li class="nav-item"> <a class="nav-link" data-toggle="tab" href="#agregar" role="tab"><span class="hidden-sm-up"><i class="ti-pencil-alt"></i></span> <span class="hidden-xs-down">Agregar</span></a> </li>
            <li class="nav-item"> <a class="nav-link" data-toggle="tab" href="#messages" role="tab"><span class="hidden-sm-up"><i class=""></i></span> <span class="hidden-xs-down">.</span></a> </li>
            <div class="col-md-7 align-self-center text-right" id=""></div>
            <div class="d-flex">
                <div class="ml-auto ">
                    <div class="form-group">
                        <input id="demo-input-search2" type="text" placeholder="Buscar" autocomplete="off">
                    </div>
                </div>
            </div>
        </ul>
        <!-- Tab panes Lista en tabla -->
        <div class="tab-content tabcontent-border">
            <div class="tab-pane active" id="lista" role="tabpanel">

                    <div class="card-header bg-success">
                        <h4 class="m-b-0 text-white"> 
                        Estudiantes : 
                            <strong><?php 
                            if (!empty($curso) && is_array($curso)) {echo $curso[0]->nombreCurso . " " . $curso[0]->nombreParalelo;}
                            ?></strong>
                        </h4>
                    </div>
                    <br>

                <!-- listar -->
                <div class="table-responsive">
                    <table id="demo-foo-addrow2" class="color-bordered-table info-bordered-table" data-page-size="20">
                        <thead>
                            <tr>
                                <th data-sort-initial="false" data-toggle="true">Nro</th>
                                <th >Apellido Paterno</th>  <!-- data-hide="phone, tablet" (esconde la columna cuando esta en modo movil)-->
                                <th data-sort-ignore="true">Apellido Materno</th>
                                <th>Nombres</th>
                                <th>Cédula</th>
                                <th>Rude</th>
                                <th>Celular</th>
                                <th data-sort-ignore="true" class="min-width">Acciones</th>
                            </tr>
                        </thead>



                        <tbody>

                            <?php
                            $indice = 1;
                            foreach ($estudiantes as $row) {
                            ?>
                                <tr>
                                    <td><?php echo $indice; ?></td>
                                    <td><?php echo ucwords(strtolower($row->primerApellido)); ?></td>
                                    <td><?php echo ucwords(strtolower($row->segundoApellido)); ?></td>
                                    <td><?php echo ucwords(strtolower($row->nombres)); ?></td>
                                    <td><?php echo $row->cedula; ?></td>
                                    <td><?php echo $row->rude; ?></td>
                                    <td><?php echo $row->celular; ?></td>
                                    <td>
                                        <a type="button" class="btn waves-effect waves-light btn-xs btn-info" href="<?php echo base_url('estudiante/edit') . "/" . $row->idEstudiante; ?>"><i class="ti-pencil"></i></a>
                                        <button type="button" class="btn waves-effect waves-light btn-xs btn-danger" onclick="deleteConfirm(<?php echo $row->idEstudiante; ?>)"><i class="ti-trash"></i></button>
                                        <button type="button" class="btn waves-effect waves-light btn-xs btn-info" onclick="verObservacionEstudiante(<?php echo $row->idEstudiante; ?>)"><i class="ti-eye"></i></button>
                                    </td>
                                </tr>
                            <?php
                                $indice++;
                            }
                            ?>

                        </tbody>
                        <tfoot>
                            <tr>
                                <td colspan="6">
                                    <div class="text-right">
                                        <ul class="pagination">
                                        </ul>
                                    </div>
                                </td>
                            </tr>
                        </tfoot>
                    </table>
                </div>




            </div>


            <div class="tab-pane" id="agregar" role="tabpanel">
                <!-- agregar -->
                <div class="card border-success">
                    <div class="card-header bg-success">
                        <h4 class="m-b-0 text-white">Registrar Estudiante</h4>
                    </div>
                    <div class="card-body">
                    <form id="formRegistroEstudiante">
                        <div class="form-row has-success">
                            <div class="col-md-4 mb-3">
                                <label for="txtNombres">Nombres</label>
                                <input type="text" class="form-control" id="txtNombres" name="txtNombres" placeholder="Nombres" required>
                            </div>
                            <div class="col-md-4 mb-3">
                                <label for="txtApellidoPaterno">Apellido Paterno</label>
                                <input type="text" class="form-control" id="txtApellidoPaterno" name="txtApellidoPaterno" placeholder="Apellido Paterno" required>
                            </div>
                            <div class="col-md-4 mb-3">
                                <label for="txtApellidoMaterno">Apellido Materno</label>
                                <input type="text" class="form-control" id="txtApellidoMaterno" name="txtApellidoMaterno" placeholder="Apellido Materno">
                            </div>
                        </div>
                        
                        <div class="form-row has-success">
                            <div class="col-md-4 mb-3">
                                <label for="txtCi">Cédula de Identidad</label>
                                <input type="text" class="form-control" id="txtCi" name="txtCi" placeholder="Cédula de identidad">
                            </div>
                            <div class="col-md-4 mb-3">
                                <label for="txtRude">Rude</label>
                                <input type="text" class="form-control" id="txtRude" name="txtRude" placeholder="Rude">
                            </div>
                            <div class="col-md-4 mb-3">
                                <label for="txtCelular">Número de Celular</label>
                                <input type="text" class="form-control" id="txtCelular" name="txtCelular" placeholder="Número de Celular" required>
                            </div>
                        </div>
                        
                        <button class="btn btn-success" type="submit"><i class="ti-save"></i> Agregar</button>
                        <a class="btn btn-dark" href="<?php echo base_url('estudiante') ?>"><i class="ti-angle-double-left"></i> Cancelar</a>
                    </form>


                    </div>
                </div>





            </div>
                            <!-- Registro masivo inicio -->
            <div class="tab-pane" id="messages" role="tabpanel">

                <h4>Registro masivo</h4>
                <button id="descargarPlantilla" class="btn btn-success">Descargar Plantilla</button>

                <form id="formSubirExcel" enctype="multipart/form-data">
                    <input type="file" id="archivoExcel" name="archivoExcel" class="form-control" accept=".xlsx, .xls">
                    <button type="submit" class="btn btn-primary mt-2">Cargar Estudiantes</button>
                </form>
                <div id="mensaje"></div>


            </div>

        </div>
    </div>
</div>

<script>
document.getElementById("formRegistroEstudiante").addEventListener("submit", function (event) {
    event.preventDefault(); // Evita que el formulario se recargue

    // Capturar los valores del formulario
    const formData = {
        nombres: document.getElementById("txtNombres").value.trim(),
        primerApellido: document.getElementById("txtApellidoPaterno").value.trim(),
        segundoApellido: document.getElementById("txtApellidoMaterno").value.trim(),
        cedula: document.getElementById("txtCi").value.trim(),
        rude: document.getElementById("txtRude").value.trim(),
        celular: document.getElementById("txtCelular").value.trim(),
        idCurso: "<?php echo $curso[0]->idCurso; ?>",   // Agregando idCurso
        idParalelo: "<?php echo $curso[0]->idParalelo; ?>", // Agregando idParalelo
        idNivel: "1",
        idInstitucion: "<?php echo $idInstitucion; ?>"
    };

    // Enviar datos al servidor con fetch()
    fetch("<?php echo base_url('estudiante/insert'); ?>", {
        method: "POST",
        headers: {
            "Content-Type": "application/json"
        },
        body: JSON.stringify(formData)
    })
    .then(response => response.json())
    .then(data => {
        console.log("Respuesta del servidor:", data);
        if (data.success) {
            swal({   
            title: "¡Registro exitoso!",   
            text: "El estudiante ha sido registrado",   
            timer: 3000,   
            showConfirmButton: true 
        });
        // $.toast({
        //     heading: '¡Registro exitoso!',
        //     text: 'El estudiante ha sido registrado.',
        //     position: 'bottom-right',
        //     loaderBg:'#ff6849',
        //     icon: 'success',
        //     hideAfter: 2500, 
        //     stack: 10
        // });

        // Esperar 2 segundos (2000 ms) antes de recargar la página
        setTimeout(() => {
            location.reload();
        }, 2000);

        } else {
            //alert("Error al registrar estudiante: " + data.message);
            swal({   
            title: "¡Ocurrió un error!",   
            text: "Error al registrar estudiante: " + data.message,   
            timer: 5000,   
            showConfirmButton: true 
        });
        }
    })
    .catch(error => {
        //console.error("Error en la solicitud:", error);
        //alert("Ocurrió un error. Inténtelo nuevamente.");
        swal({   
            title: "¡Ocurrió un error!",   
            text: "Ocurrió un error. Inténtelo nuevamente.",   
            timer: 5000,   
            showConfirmButton: true 
        });
    });
});

// descargar Plantilla
    document.getElementById("descargarPlantilla").addEventListener("click", function() {
            window.location.href = "<?= base_url('estudiante/descargarPlantilla'); ?>";
        });

// cargar Plantilla
document.getElementById("formSubirExcel").addEventListener("submit", function(event) {
    event.preventDefault();
    let formData = new FormData();
    let archivo = document.getElementById("archivoExcel").files[0];

    if (!archivo) {
        swal("Por favor, selecciona un archivo.");
        return;
    }

    // Agregar el archivo Excel
    formData.append("archivoExcel", archivo);

    // Agregar los valores adicionales
    formData.append("idCurso", "<?= $curso[0]->idCurso; ?>");
    formData.append("idParalelo", "<?= $curso[0]->idParalelo; ?>");
    formData.append("idNivel", "1");
    formData.append("idInstitucion", "<?= $idInstitucion; ?>");

    // Enviar los datos al controlador
    fetch("<?= base_url('estudiante/subirExcel'); ?>", {
        method: "POST",
        body: formData
    })
    .then(response => response.json())
    .then(data => {
        document.getElementById("mensaje").innerHTML = data.message;
    })
    .catch(error => console.error("Error:", error));
});

//obtener la observacion del estudiante
function verObservacionEstudiante(idEstudiante) {
    fetch("<?= base_url('estudiante/getObservacion'); ?>", {
        method: "POST",
        headers: {
            "Content-Type": "application/json"
        },
        body: JSON.stringify({ idEstudiante: idEstudiante })
    })
    .then(response => response.json())
    .then(data => {
        if (data.status === "success") {
            //console.log(data);
            document.getElementById("idEstudianteInput").value = idEstudiante;
            document.getElementById("observacionInput").value = data.observacion;
            document.getElementById("estudianteOb").textContent = data.estudiante; // Asegurar que el nombre se muestre
            $("#modalObservacion").modal("show"); // Mostrar el modal
        } else {
            swal("Error!", data.message, "error");
        }
    })
    .catch(error => console.error("Error en la petición:", error));
}

// Guardar la observación actualizada
document.getElementById("btnActualizarObservacion").addEventListener("click", function () {
    let idEstudiante = document.getElementById("idEstudianteInput").value;
    //let observacion = document.getElementById("observacionInput").value;
    let observacion = $('#observacionInput').val();

    let payload = {
        idEstudiante: idEstudiante,
        observacion: observacion
    };

    fetch("<?= base_url('estudiante/updateObservacion'); ?>", {
        method: "POST",
        headers: {
            "Content-Type": "application/json"
        },
        body: JSON.stringify(payload)
    })
    .then(response => response.json())
    .then(data => {
        if (data.status === "success") {
            swal("Actualizado!", "La observación ha sido actualizada.", "success");
            $("#modalObservacion").modal("hide"); // Cerrar el modal
            location.reload(); // Recargar la página para ver los cambios
        } else {
            swal("Error!", data.message, "error");
        }
    })
    .catch(error => console.error("Error en la petición:", error));
});



</script>


<?php 
// }else{
//     redirect('login','refresh');
// }
?>