<?php
//if ($this->session->userdata('estudiante')) {
?>

<!---script de confirmacion para delete-->
<script type="text/javascript">

</script>



<?php
//print_r($cursos);
//print_r($paralelos);
?>

<!-- Modal Inicial -->
<!-- Modal de Detalles de Asistencia -->
<div id="detalleAsistenciaModal" class="modal fade" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document"> <!-- Ampliamos el tamaño del modal -->
        <div class="modal-content">
        
            <!-- Encabezado del Modal -->
            <div class="modal-header bg-success text-white">
                <h4 class="modal-title">Detalles de Asistencia</h4>
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
            </div>

            <!-- Contenido -->
            <div class="modal-body p-4">
                <div class="mb-3 text-center">
                    <h4 class="fw-bold">Estudiante: <span id="nombreEstudiante"></span></h4>
                </div>

                <!-- Inputs ocultos -->
                <input type="hidden" name="fechaInicioModal" id="fechaInicioModal">
                <input type="hidden" name="fechaFinalModal" id="fechaFinalModal">
                <input type="hidden" name="idEstudianteModal" id="idEstudianteModal">

                <!-- Tabla de detalles -->
                <div class="table-responsive">
                    <table class="color-bordered-table info-bordered-table">
                        <thead class="table-success text-center">
                            <tr>
                                <th>Tipo</th>
                                <th>Total</th>
                                <th>Fechas</th>
                            </tr>
                        </thead>
                        <tbody id="detalleAsistenciaBody">
                            <!-- Aquí se insertarán los datos dinámicamente -->
                        </tbody>
                    </table>
                </div>
            </div>

            <!-- Pie del Modal -->
            <div class="modal-footer">
                <button type="button" class="btn btn-default waves-effect" data-dismiss="modal">Cerrar</button>
                <button type="button" class="btn btn-success waves-effect waves-light" name="btnIndividualGenerarPDF" id="btnIndividualGenerarPDF" class="btn btn-info">
                    Generar PDF
                </button>
            </div>

        </div>
    </div>
</div>



<!-- Modal fin -->

<div class="card mt-3">
    <div class="card-body">
        <!-- Nav tabs -->
        <ul class="nav nav-tabs" role="tablist">
            <li class="nav-item"> <a class="nav-link active" data-toggle="tab" href="#lista" role="tab"><span class="hidden-sm-up"><i class="ti-clipboard"></i></span> <span class="hidden-xs-down">Reporte</span></a> </li>
            <!-- <li class="nav-item"> <a class="nav-link" data-toggle="tab" href="#agregar" role="tab"><span class="hidden-sm-up"><i class="ti-pencil-alt"></i></span> <span class="hidden-xs-down">Por estudiante</span></a> </li>
            <li class="nav-item"> <a class="nav-link" data-toggle="tab" href="#messages" role="tab"><span class="hidden-sm-up"><i class=""></i></span> <span class="hidden-xs-down">.</span></a> </li> -->
            <div class="col-md-7 align-self-center text-right" id=""></div>

        </ul>
        <!-- Tab panes Lista en tabla -->
        <div class="tab-content tabcontent-border">
            <div class="tab-pane active" id="lista" role="tabpanel">

                <div class="card-header bg-success">
                    <h4 class="m-b-0 text-white"> 
                    Reporte
                    </h4>
                </div>
                <br>

                
                <div class="form-row">
                    <div class="col-md-2 mb-3 has-success">
                        <div class="input-field">
                            <label for="email1">Fecha Inicio</label>
                            <input type="date" class="form-control" id="dtpFechaInicio" name="dtpFechaInicio" step="1" min="2019-01-01" value="<?php echo date("Y-m-d");?>">
                            
                        </div>
                    </div>
                    <div class="col-md-2 mb-3 has-success">
                        <div class="input-field">
                        <label for="email1">Fecha Final</label>
                            <input type="date" class="form-control" id="dtpFechaFinal" name="dtpFechaFinal" step="1" min="2019-01-01" value="<?php echo date("Y-m-d");?>">
                            
                        </div>
                    </div>
                    <div class="col-md-2 mb-3 has-success">
                        <label for="email1">Curso</label>
                        <select class="form-control custom-select" name="curso" id="curso">
                            
                            <?php foreach ($cursos as $row): ?>
                                <option value="<?php echo $row->idCurso; ?>">
                                    <?php echo $row->cortoCurso?>
                                </option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <div class="col-md-2 mb-3 has-success">
                        <label for="email1">Paralelo</label>
                        <select class="form-control custom-select" name="paralelo" id="paralelo">
                        
                            <?php foreach ($paralelos as $row): ?>
                                <option value="<?php echo $row->idParalelo; ?>">
                                    <?php echo $row->nombreParalelo; ?>
                                </option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <div class="col-md-2 mb-3 has-success">
                        <label for="email1">Retraso o falta</label>
                        <select class="form-control custom-select" name="retrasoFalta" id="retrasoFalta">
                                <option value="3">3</option>
                                <option value="4">4</option>
                                <option value="5">5</option>
                                <option value="6">6</option>
                                <option value="7">7</option>
                                <option value="8">8</option>
                                <option value="9">9</option>
                        </select>
                    </div>
                    <div class="button-group">
                    
                        <button type="submit" class="btn waves-effect waves-light btn-success" id="btnVerReporte" name="btnVerReporte"><i class="ti-save"></i> Ver reporte</button>
                        <button type="submit" class="btn waves-effect waves-light btn-info" id="btnGenerarPDF" name="btnGenerarPDF"><i class="ti-file"></i> Generar PDF</button>
                    </div>

                </div>
                



                <!-- listar -->
                <div style="overflow-x:auto;" class="table-responsive">
                    <table id="demo-foo-addrow2" class="color-bordered-table info-bordered-table" data-page-size="20">
                        <thead>
                            <tr>
                                <th data-sort-initial="false" data-toggle="true">Nro</th>
                                <th class="nombre-columna nombre-col">Estudiante</th>
                                <th data-sort-ignore="true">Asistencias</th>
                                <th data-sort-ignore="true">Retrasos</th>
                                <th data-sort-ignore="true" class="min-width">Ausencias</th>
                                <th data-sort-ignore="true" class="min-width">Licencias</th>
                                <th data-sort-ignore="true" class="min-width">Citación</th>
                                <th data-sort-ignore="true" class="min-width">Detalles</th>
                            </tr>
                        </thead>



                        <tbody>
                            <td>-</td>
                            <td class="nombre-columna nombre-col">-</td>
                            <td>-</td>
                            <td>-</td>
                            <td>-</td>
                            <td>-</td>
                            <td>-</td>
                            <td>-</td>

                        </tbody>
                        <tfoot>
                            <tr>
                                <td colspan="6">
                                    <div class="text-right">
                                        <ul class="pagination">
                                        </ul>
                                    </div>
                                </td>
                            </tr>
                        </tfoot>
                    </table>
                </div>




            </div>


            <div class="tab-pane" id="agregar" role="tabpanel">
                <!-- agregar inicio-->

                <!-- agregar final -->
            </div>



        </div>
    </div>
</div>

<script>

$(document).ready(function() {
    $('#btnVerReporte').click(function(e) {
        e.preventDefault();

        let fechaInicio = $('#dtpFechaInicio').val();
        let fechaFinal = $('#dtpFechaFinal').val();
        let curso = $('#curso').val();
        let paralelo = $('#paralelo').val();
        let cursoNombre = $('#curso option:selected').text().trim() + ' ' + $('#paralelo option:selected').text().trim();
        let retrasoFalta = $('#retrasoFalta').val();

        $.ajax({
            url: 'reporte/reporteAsistencias', // URL de tu controlador
            type: 'POST',
            data: {
                fechaInicio: fechaInicio,
                fechaFinal: fechaFinal,
                curso: curso,
                paralelo: paralelo
            },
            dataType: 'json',
            success: function(response) {
                if (response.status === 'success') {  
                    let tbody = '';
                    //console.log("Respuesta del servidor:", response.data);
                    $.each(response.data, function(index, item) {
                        let btnGenerarCitacionPDF = '';
                        let btnVerDetalle = '';
                        //console.log("Respuesta del servidor:", item.totalRetrasos);
                        // Si totalRetrasos o totalAusencias es 3 o mayor, mostrar el botón
                        if (Number(item.totalRetrasos) >= retrasoFalta || Number(item.totalAusencias) >= retrasoFalta) {
                            btnGenerarCitacionPDF = `<button class="btn btn-danger btnGenerarCitacionPDF asistencia-btn"
                                                data-nombre="${item.nombres} ${item.primerApellido}"
                                                data-cursonombre="${cursoNombre}"
                                                data-celular="${item.celular}"
                                                data-totalretrasos="${item.totalRetrasos}"  
                                                data-totalausencias="${item.totalAusencias}"
                                                data-totallicencias="${item.totalLicencias}"
                                                data-fechainicio="${fechaInicio}"  
                                                data-fechafinal="${fechaFinal}">
                                                Citación PDF
                                            </button>`;
                        }


                        btnVerDetalle = `<button class="btn btn-info btnVerDetalle asistencia-btn"
                                                data-fechainicio="${fechaInicio}"  
                                                data-fechafinal="${fechaFinal}"
                                                data-idestudiante="${item.idEstudiante}">
                                                Ver Detalle
                                            </button>`;

                        tbody += `<tr>
                                    <td>${index + 1}</td>
                                    <td class="nombre-columna nombre-col">
                                    ${capitalizar(item.primerApellido)} ${capitalizar(item.segundoApellido)} ${capitalizar(item.nombres)}
                                    </td>
                                    <td>${item.totalAsistencias}</td>
                                    <td>${item.totalRetrasos}</td>
                                    <td>${item.totalAusencias}</td>
                                    <td>${item.totalLicencias}</td>
                                    <td>${btnGenerarCitacionPDF}</td>
                                    <td>${btnVerDetalle}</td>
                                  </tr>`;
                    });

                    $('#demo-foo-addrow2 tbody').html(tbody);
                } else {
                    swal('No se encontraron datos');
                }
            },
            error: function(xhr, status, error) {
                console.error(error);
                swal('Hubo un error en la solicitud');
            }
        });
    });

    // GEnerar reporte total del curso completo
    $('#btnGenerarPDF').click(function(e) {
        e.preventDefault();

        let fechaInicio = $('#dtpFechaInicio').val();
        let fechaFinal = $('#dtpFechaFinal').val();
        let curso = $('#curso').val();
        let paralelo = $('#paralelo').val();

        //console.log("Datos enviados:", { fechaInicio, fechaFinal, curso, paralelo });
        window.open(
                'reporte/reporteAsistenciaPorCursoPDF'+'/'+fechaInicio+'/'+fechaFinal+'/'+curso+'/'+paralelo,
                '_blank' // <- Esto es lo que hace que se abra en una nueva ventana.
            );
        
    });



    $(document).on('click', '.btnGenerarCitacionPDF', function (e) {
    e.preventDefault();

    let datos = {
        nombre: $(this).data('nombre'),
        cursoNombre: $(this).data('cursonombre'),
        celular: $(this).data('celular'),
        totalRetrasos: $(this).data('totalretrasos') || 0,
        totalAusencias: $(this).data('totalausencias') || 0,
        totalLicencias: $(this).data('totallicencias') || 0,
        fechaInicio: $(this).data('fechainicio') || 'No definido',
        fechaFinal: $(this).data('fechafinal') || 'No definido'
    };

    let nombreArchivo = `${datos.nombre} (${datos.cursoNombre})`
        .replace(/[^a-zA-Z0-9\s\(\)]/g, '')  // Eliminar caracteres especiales
        .replace(/\s+/g, '_');  // Reemplazar espacios por guiones bajos

    $.ajax({
        url: 'reporte/generarCitacion',
        type: 'POST',
        data: datos,
        dataType: 'json',  // Esperamos un JSON con la URL del archivo
        success: function (response) {
            if (response.status === 'success') {
                // Asegúrate de que la URL sea válida (comienza con http:// o https://)
                let urlPDF = response.url.startsWith('http') ? response.url : 'https://' + response.url;

                let celular = datos.celular;

                // Mensaje con enlace clickeable en WhatsApp
                let mensaje = `Estimado padre/madre/tutor, se ha generado una citación para el estudiante *${datos.nombre}* (${datos.cursoNombre}).\n\n📄 Puede ver la citación en el siguiente enlace:\n\n👉 ${urlPDF} \n\nGracias.`;

                // Generar el enlace de WhatsApp
                let urlWhatsApp = `https://api.whatsapp.com/send?phone=${celular}&text=${encodeURIComponent(mensaje)}`;

                // Redirigir a WhatsApp con el mensaje
                window.open(urlWhatsApp, '_blank');
            } else {
                swal('Error al generar la citación.');
            }
        },
        error: function (xhr, status, error) {
            console.error(error);
            swal('Error al generar la citación.');
        }
    });
});

// boton ver Detalle -  se gerenara el modal
    $(document).on('click', '.btnVerDetalle', function (e) {
        e.preventDefault();
        let id=$(this).data('idestudiante');
        let datos = {
            fechaInicio: $(this).data('fechainicio') || 'No definido',
            fechaFinal: $(this).data('fechafinal') || 'No definido',
            idEstudiante: $(this).data('idestudiante')
        };

        $.ajax({
            url: 'reporte/verDetalle',
            type: 'POST',
            data: datos,
            dataType: 'json',  // Esperamos un JSON con la URL del archivo
            success: function (response) {
                if (response.status === 'success') {
                    //console.log("Respuesta del backend:", response);
                    let data = response.data;
                    let tbody = "";

                    // Asignar el nombre del estudiante en el modal
                    $('#nombreEstudiante').text(data.nombreEstudiante);
                    $('#fechaInicioModal').text(data.fechaInicio);
                    $('#fechaFinalModal').text(data.fechaFinal);
                    $('#idEstudianteModal').text(data.idEstudiante);

                    tbody += `<tr>
                                <td>Ausencias</td>
                                <td>${data.totalAusencias}</td>
                                <td>${data.fechasAusencias.length > 0 ? data.fechasAusencias.join(", ") : "Ninguna"}</td>
                            </tr>`;
                    
                    tbody += `<tr>
                                <td>Retrasos</td>
                                <td>${data.totalRetrasos}</td>
                                <td>${data.fechasRetrasos.length > 0 ? data.fechasRetrasos.join(", ") : "Ninguna"}</td>
                            </tr>`;

                    tbody += `<tr>
                                <td>Licencias</td>
                                <td>${data.totalLicencias}</td>
                                <td>${data.fechasLicencias.length > 0 ? data.fechasLicencias.join(", ") : "Ninguna"}</td>
                            </tr>`;

                    // Insertar en la tabla
                    $('#detalleAsistenciaBody').html(tbody);

                    // Mostrar la modal
                    $('#detalleAsistenciaModal').modal('show');

                } else {
                    swal('Error al generar la citación.');
                }
            },
            error: function (xhr, status, error) {
                console.error(error);
                swal('Error al generar la citación.');
            }
        });


    });



});



    
// boton generar reporte individula PDF del modal
    $(document).on('click', '#btnIndividualGenerarPDF', function () {

    let idEstudiante = $('#idEstudianteModal').text();
    let fechaInicio = $('#fechaInicioModal').text();
    let fechaFinal = $('#fechaFinalModal').text();
    let cursoNombre = $('#curso option:selected').text().trim() + ' ' + $('#paralelo option:selected').text().trim();
    console.log(cursoNombre);
    let datos = {
        idEstudiante: idEstudiante,
        fechaInicio: fechaInicio,
        fechaFinal: fechaFinal,
        cursoNombre: cursoNombre
    };

    $.ajax({
        url: 'reporte/generarPDF',
        type: 'POST',
        data: datos,
        dataType: 'json',
        success: function (response) {
            if (response.status === 'success') {
                swal("Éxito", "PDF generado con éxito. Se enviará el enlace al celular.");

                // Compartir el enlace por WhatsApp
                let mensaje = `Estimado padre/madre/tutor, se ha generado un reporte de asistencia para el/la estudiante: ${response.pdfUrl}`;
                let numero = response.numeroCelular;
                let urlWhatsapp = `https://wa.me/${numero}?text=${encodeURIComponent(mensaje)}`;

                window.open(urlWhatsapp, '_blank');
            } else {
                swal("Error", "No se pudo generar el PDF.", "error");
            }
        },
        error: function (xhr, status, error) {
            console.error(error);
            swal("Error", "Hubo un problema al generar el PDF.", "error");
        }
    });
});




function capitalizar(texto) {
    return texto.toLowerCase().replace(/\b\w/g, letra => letra.toUpperCase());
}



</script>

<?php 
// }else{
//     redirect('login','refresh');
// }
?>