<?php
//if ($this->session->userdata('estudiante')) {
?>

<!---script de confirmacion para delete-->
<script type="text/javascript">
    
    function deleteConfirm(id) {
        var baseUrl = "<?= base_url('estudiante/delete') ?>";
    if (confirm('¿Está realmente segur@ de eliminar?')) {
        $.ajax({
            url: baseUrl +"/"+ id, // URL del controlador
            type: "POST", // Método HTTP
            dataType: "json", // Tipo de datos esperados en la respuesta
            success: function(response) {
                if (response.success) {
                    alert("El estudiante ha sido eliminado correctamente.");
                    location.reload(); // Recargar la página para actualizar la lista
                } else {
                    alert("Error al eliminar el estudiante.");
                }
            },
            error: function() {
                alert("Hubo un problema con la solicitud.");
            }
        });
    }
}

</script>



<?php
//print_r($trimestres);

?>




<div class="card mt-3">
    <div class="card-body">
        <!-- Nav tabs -->
        <ul class="nav nav-tabs" role="tablist">
            <li class="nav-item"> <a class="nav-link active" data-toggle="tab" href="#lista" role="tab"><span class="hidden-sm-up"><i class="ti-clipboard"></i></span> <span class="hidden-xs-down">Timestre</span></a> </li>
            <li class="nav-item"> <a class="nav-link" data-toggle="tab" href="#agregar" role="tab"><span class="hidden-sm-up"><i class="ti-pencil-alt"></i></span> <span class="hidden-xs-down">Trimestre activo</span></a> </li>
            <!-- <li class="nav-item"> <a class="nav-link" data-toggle="tab" href="#messages" role="tab"><span class="hidden-sm-up"><i class=""></i></span> <span class="hidden-xs-down">.</span></a> </li> -->
            <div class="col-md-7 align-self-center text-right" id=""></div>
            <div class="d-flex">
                <div class="ml-auto ">
                    <div class="form-group">
                        <input id="demo-input-search2" type="text" placeholder="Buscar" autocomplete="off">
                    </div>
                </div>
            </div>
        </ul>
        <!-- Tab panes Lista en tabla -->
        <div class="tab-content tabcontent-border">
            <div class="tab-pane active" id="lista" role="tabpanel">

                <!-- listar -->
                <div class="table-responsive">
                    <table id="demo-foo-addrow2" class="color-bordered-table info-bordered-table" data-page-size="20">
                        <thead>
                            <tr>
                                <th data-sort-initial="false" data-toggle="true">Nro</th>
                                <th>Trimestre</th>
                                <th >Fecha Inicio</th>
                                <th >Fecha Final</th>
                                <th data-sort-ignore="true" class="min-width">Acciones</th>
                            </tr>
                        </thead>



                        <tbody>

                            <?php
                            $indice = 1;
                            foreach ($trimestres as $row) {
                            ?>
                                <tr>
                                    <td><?php echo $indice; ?></td>
                                    <td><?php echo $row->nombreTrimestre; ?></td>
                                    <td><?php echo $row->fechaInicio; ?></td>
                                    <td><?php echo $row->fechaFinal; ?></td>
                                    <td>
                                        <a type="button" class="btn waves-effect waves-light btn-xs btn-info" href="<?php echo base_url('trimestre/edit') . "/" . $row->idTrimestre; ?>"><i class="ti-pencil"></i></a>
                                    </td>
                                </tr>
                            <?php
                                $indice++;
                            }
                            ?>

                        </tbody>
                        <tfoot>
                            <tr>
                                <td colspan="6">
                                    <div class="text-right">
                                        <ul class="pagination">
                                        </ul>
                                    </div>
                                </td>
                            </tr>
                        </tfoot>
                    </table>
                </div>




            </div>


            <div class="tab-pane" id="agregar" role="tabpanel">
                <!-- agregar -->
                <div class="card border-success">

                    <!-- inicio agregar -->
                    <div class="form p-3">
                        <form id="formTrimestre">
                            <div id="trimestres-container"></div>
                            
                            <div class="button-group">
                                <button type="submit" class="btn waves-effect waves-light btn-success" id="btnGuardar" name="btnGuardar"><i class="ti-save"></i> Guardar cambio</button>
                                <!-- <button type="submit" class="btn waves-effect waves-light btn-info" id="btnCancelar" name="btnCancelar"><i class="ti-file"></i> Cancelar</button> -->
                            </div>
                        </form>
                        <!-- final agregar -->
                    </div>
                </div>





            </div>

            <div class="tab-pane" id="messages" role="tabpanel">

                3

            </div>

        </div>
    </div>
</div>


<script>
document.addEventListener("DOMContentLoaded", function() {
    fetch("<?= base_url('trimestre/getTrimestres') ?>")
    .then(response => response.json())
    .then(data => {
        let container = document.getElementById("trimestres-container");
        container.innerHTML = ""; // Limpiar

        data.forEach(trimestre => {
            let checked = trimestre.estado == 1 ? "checked" : "";

            container.innerHTML += `
                <label>
                    <input type="radio" name="trimestre" value="${trimestre.idTrimestre}" ${checked}>
                    ${trimestre.nombreTrimestre}
                </label><br>
            `;
        });
    })
    .catch(error => console.error("Error al cargar trimestres:", error));
});

// Enviar actualización
document.getElementById("formTrimestre").addEventListener("submit", function(event) {
    event.preventDefault();

    let idTrimestre = document.querySelector('input[name="trimestre"]:checked').value;

    fetch("<?= base_url('trimestre/actualizarTrimestre') ?>", {
        method: "POST",
        headers: { "Content-Type": "application/json" },
        body: JSON.stringify({ idTrimestre: idTrimestre })
    })
    .then(response => response.json())
    .then(data => {
        //swal("¡Éxito!", data.message, "success");
        swal({   
            title: "¡Éxito!",   
            text: data.message,   
            timer: 3000,   
            showConfirmButton: true 
        });
            //location.reload();
        
    })
    .catch(error => {
        swal("¡Error!", "No se pudo cambiar el trimestre.", "error");
    });
});
</script>



<?php 
// }else{
//     redirect('login','refresh');
// }
?>